/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import org.apache.cayenne.access.types.EnumType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.InnerEnumHolder;
import org.apache.cayenne.access.types.MockEnum;
import org.apache.cayenne.access.types.MockEnum2;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtendedTypeMapEnumsTest {
    private ExtendedTypeMap map;

    @Before
    public void before() {
        this.map = new ExtendedTypeMap();
    }

    @Test
    public void testCreateType_NoFactory() {
        Assert.assertNull((Object)this.map.createType(Object.class.getName()));
    }

    @Test
    public void testCreateType_Enum() {
        ExtendedType type1 = this.map.createType(MockEnum.class.getName());
        Assert.assertTrue((boolean)(type1 instanceof EnumType));
        Assert.assertEquals(MockEnum.class, ((EnumType)type1).enumClass);
        ExtendedType type2 = this.map.createType(MockEnum2.class.getName());
        Assert.assertNotSame((Object)type1, (Object)type2);
    }

    @Test
    public void testCreateType_InnerEnum() {
        ExtendedType type = this.map.createType(InnerEnumHolder.InnerEnum.class.getName());
        Assert.assertTrue((boolean)(type instanceof EnumType));
        Assert.assertEquals(InnerEnumHolder.InnerEnum.class, ((EnumType)type).enumClass);
        ExtendedType type1 = this.map.createType(InnerEnumHolder.class.getName() + "$InnerEnum");
        Assert.assertNotNull((Object)type1);
        Assert.assertEquals((Object)type.getClassName(), (Object)type1.getClassName());
        ExtendedType type2 = this.map.createType(InnerEnumHolder.class.getName() + ".InnerEnum");
        Assert.assertNotNull((Object)type2);
        Assert.assertEquals((Object)type.getClassName(), (Object)type2.getClassName());
    }

    @Test
    public void testGetRegisteredType() {
        ExtendedType type = this.map.getRegisteredType(MockEnum.class);
        Assert.assertNotNull((Object)type);
        Assert.assertTrue((boolean)(type instanceof EnumType));
        Assert.assertSame((Object)type, (Object)this.map.getRegisteredType(MockEnum.class));
        Assert.assertSame((Object)type, (Object)this.map.getRegisteredType(MockEnum.class.getName()));
    }

    @Test
    public void testGetRegisteredType_InnerEnum() {
        Assert.assertEquals((long)0L, (long)this.map.extendedTypeFactories.size());
        ExtendedType byType = this.map.getRegisteredType(InnerEnumHolder.InnerEnum.class);
        Assert.assertEquals((long)1L, (long)this.map.extendedTypeFactories.size());
        Assert.assertSame((Object)byType, (Object)this.map.getRegisteredType(InnerEnumHolder.InnerEnum.class));
        Assert.assertEquals((long)1L, (long)this.map.extendedTypeFactories.size());
        Assert.assertSame((Object)byType, (Object)this.map.getRegisteredType(InnerEnumHolder.class.getName() + "$InnerEnum"));
        Assert.assertEquals((long)1L, (long)this.map.extendedTypeFactories.size());
        Assert.assertSame((Object)byType, (Object)this.map.getRegisteredType(InnerEnumHolder.class.getName() + ".InnerEnum"));
        Assert.assertEquals((long)1L, (long)this.map.extendedTypeFactories.size());
    }
}

