/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.batch.DefaultBatchTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DefaultBatchTranslatorIT
extends ServerCase {
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testConstructor() throws Exception {
        DbAdapter adapter = (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
        DefaultBatchTranslator builder = new DefaultBatchTranslator((BatchQuery)Mockito.mock(BatchQuery.class), adapter, null){

            @Override
            protected String createSql() {
                return null;
            }

            @Override
            protected DbAttributeBinding[] createBindings() {
                return new DbAttributeBinding[0];
            }

            @Override
            protected DbAttributeBinding[] doUpdateBindings(BatchQueryRow row) {
                return new DbAttributeBinding[0];
            }
        };
        Assert.assertSame((Object)adapter, (Object)builder.adapter);
    }

    @Test
    public void testAppendDbAttribute1() throws Exception {
        DbAdapter adapter = (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
        String trimFunction = "testTrim";
        DefaultBatchTranslator builder = new DefaultBatchTranslator((BatchQuery)Mockito.mock(BatchQuery.class), adapter, trimFunction){

            @Override
            protected String createSql() {
                return null;
            }

            @Override
            protected DbAttributeBinding[] createBindings() {
                return new DbAttributeBinding[0];
            }

            @Override
            protected DbAttributeBinding[] doUpdateBindings(BatchQueryRow row) {
                return new DbAttributeBinding[0];
            }
        };
        StringBuilder buf = new StringBuilder();
        DbEntity entity = new DbEntity("Test");
        DbAttribute attr = new DbAttribute("testAttr", 1, null);
        attr.setEntity(entity);
        builder.appendDbAttribute(buf, attr);
        Assert.assertEquals((Object)"testTrim(testAttr)", (Object)buf.toString());
        buf = new StringBuilder();
        attr = new DbAttribute("testAttr", 12, null);
        attr.setEntity(entity);
        builder.appendDbAttribute(buf, attr);
        Assert.assertEquals((Object)"testAttr", (Object)buf.toString());
    }

    @Test
    public void testAppendDbAttribute2() throws Exception {
        DbAdapter adapter = (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
        DefaultBatchTranslator builder = new DefaultBatchTranslator((BatchQuery)Mockito.mock(BatchQuery.class), adapter, null){

            @Override
            protected String createSql() {
                return null;
            }

            @Override
            protected DbAttributeBinding[] createBindings() {
                return new DbAttributeBinding[0];
            }

            @Override
            protected DbAttributeBinding[] doUpdateBindings(BatchQueryRow row) {
                return new DbAttributeBinding[0];
            }
        };
        StringBuilder buf = new StringBuilder();
        DbEntity entity = new DbEntity("Test");
        DbAttribute attr = new DbAttribute("testAttr", 1, null);
        attr.setEntity(entity);
        builder.appendDbAttribute(buf, attr);
        Assert.assertEquals((Object)"testAttr", (Object)buf.toString());
        buf = new StringBuilder();
        attr = new DbAttribute("testAttr", 12, null);
        attr.setEntity(entity);
        builder.appendDbAttribute(buf, attr);
        Assert.assertEquals((Object)"testAttr", (Object)buf.toString());
    }
}

