/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.UUID;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.uuid.UuidPkEntity;
import org.apache.cayenne.testdo.uuid.UuidTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-uuid.xml")
public class UUIDIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper uuidPkEntity;

    @Before
    public void setUp() throws Exception {
        this.uuidPkEntity = new TableHelper(this.dbHelper, "UUID_PK_ENTITY", new String[]{"ID"});
    }

    @Test
    public void testUUID() throws Exception {
        UuidTestEntity test = this.context.newObject(UuidTestEntity.class);
        UUID id = UUID.randomUUID();
        test.setUuid(id);
        this.context.commitChanges();
        SelectQuery<UuidTestEntity> q = new SelectQuery<UuidTestEntity>(UuidTestEntity.class);
        UuidTestEntity testRead = (UuidTestEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getUuid());
        Assert.assertEquals((Object)id, (Object)testRead.getUuid());
        test.setUuid(null);
        this.context.commitChanges();
    }

    @Test
    public void testUUIDMeaningfulPkInsert() throws Exception {
        UUID id = UUID.randomUUID();
        UuidPkEntity o1 = this.context.newObject(UuidPkEntity.class);
        o1.setId(id);
        this.context.commitChanges();
        String fetched = this.uuidPkEntity.getString("ID");
        Assert.assertEquals((Object)id, (Object)UUID.fromString(fetched));
    }

    @Test
    public void testUUIDMeaningfulPkSelect() throws Exception {
        UUID id = UUID.randomUUID();
        this.uuidPkEntity.insert(new Object[]{id.toString()});
        UuidPkEntity o1 = Cayenne.objectForPK(this.context, UuidPkEntity.class, (Object)id);
        Assert.assertNotNull((Object)o1);
        Assert.assertEquals((Object)id, (Object)o1.getId());
        Assert.assertEquals((Object)id, (Object)o1.getObjectId().getIdSnapshot().get("ID"));
    }

    @Test
    public void testUUIDColumnSelect() throws Exception {
        UuidTestEntity test = this.context.newObject(UuidTestEntity.class);
        UUID id = UUID.randomUUID();
        test.setUuid(id);
        this.context.commitChanges();
        UUID readValue = (UUID)ObjectSelect.query(UuidTestEntity.class).column(UuidTestEntity.UUID).selectOne(this.context);
        Assert.assertEquals((Object)id, (Object)readValue);
        UUID readValue2 = (UUID)ObjectSelect.query(UuidTestEntity.class).column(Property.create(ExpressionFactory.dbPathExp("UUID"), UUID.class)).selectOne(this.context);
        Assert.assertEquals((Object)id, (Object)readValue2);
    }
}

