/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.FlattenedArcKey;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedTest1;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedTest3;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-flattened.xml")
public class FlattenedArcKeyIT
extends ServerCase {
    @Inject
    private EntityResolver entityResolver;

    @Test
    public void testAttributes() {
        ObjectId src = new ObjectId("X");
        ObjectId target = new ObjectId("Y");
        ObjRelationship r1 = this.entityResolver.getObjEntity(FlattenedTest3.class).getRelationship(FlattenedTest3.TO_FT1.getName());
        FlattenedArcKey update = new FlattenedArcKey(src, target, r1);
        Assert.assertSame((Object)src, (Object)update.id1.getSourceId());
        Assert.assertSame((Object)target, (Object)update.id2.getSourceId());
        Assert.assertSame((Object)r1, (Object)update.relationship);
    }

    @Test
    public void testHashCode() {
        ObjectId src = new ObjectId("X");
        ObjectId target = new ObjectId("Y");
        ObjRelationship r1 = this.entityResolver.getObjEntity(FlattenedTest3.class).getRelationship(FlattenedTest3.TO_FT1.getName());
        FlattenedArcKey update = new FlattenedArcKey(src, target, r1);
        FlattenedArcKey update1 = new FlattenedArcKey(target, src, r1.getReverseRelationship());
        ObjRelationship r3 = this.entityResolver.getObjEntity(FlattenedTest1.class).getRelationship(FlattenedTest1.FT3OVER_COMPLEX.getName());
        FlattenedArcKey update2 = new FlattenedArcKey(target, src, r3);
        int h = update.hashCode();
        int h1 = update1.hashCode();
        int h2 = update2.hashCode();
        Assert.assertTrue((h == h1 ? 1 : 0) != 0);
        Assert.assertTrue((h == update.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((h == h2 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        ObjectId src = new ObjectId("X");
        ObjectId target = new ObjectId("Y");
        ObjRelationship r1 = this.entityResolver.getObjEntity(FlattenedTest3.class).getRelationship(FlattenedTest3.TO_FT1.getName());
        FlattenedArcKey update = new FlattenedArcKey(src, target, r1);
        FlattenedArcKey update1 = new FlattenedArcKey(target, src, r1.getReverseRelationship());
        ObjRelationship r3 = this.entityResolver.getObjEntity(FlattenedTest1.class).getRelationship(FlattenedTest1.FT3OVER_COMPLEX.getName());
        FlattenedArcKey update2 = new FlattenedArcKey(target, src, r3);
        Assert.assertTrue((boolean)update.equals(update1));
        Assert.assertFalse((boolean)update.equals(update2));
    }
}

