/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.SQLException;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.inheritance_people.Employee;
import org.apache.cayenne.testdo.inheritance_people.PersonNotes;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataContextRelationshipQuery_PolymorphicIT
extends PeopleProjectCase {
    @Inject
    private DataContext context1;
    @Inject
    private DataContext context2;
    @Inject
    private DataChannelInterceptor queryInterceptor;
    private TableHelper tPerson;
    private TableHelper tPersonNotes;

    @Before
    public void before() {
        this.tPerson = new TableHelper(this.dbHelper, "PERSON").setColumns(new String[]{"PERSON_ID", "NAME", "PERSON_TYPE"}).setColumnTypes(new int[]{4, 12, 1});
        this.tPersonNotes = new TableHelper(this.dbHelper, "PERSON_NOTES").setColumns(new String[]{"ID", "PERSON_ID", "NOTES"});
    }

    @Test
    public void testPolymorphicSharedCache() throws SQLException {
        Employee e = this.context1.newObject(Employee.class);
        e.setName("E1");
        e.setSalary(Float.valueOf(1234.01f));
        PersonNotes n = this.context1.newObject(PersonNotes.class);
        n.setNotes("N1");
        n.setPerson(e);
        this.context1.commitChanges();
        final PersonNotes nPeer = Cayenne.objectForPK((ObjectContext)this.context2, PersonNotes.class, Cayenne.intPKForObject(n));
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertTrue((boolean)(nPeer.getPerson() instanceof Employee));
            }
        });
    }
}

