/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextPrefetchIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    protected TableHelper tArtist;
    protected TableHelper tPainting;
    protected TableHelper tPaintingInfo;
    protected TableHelper tExhibit;
    protected TableHelper tGallery;
    protected TableHelper tArtistExhibit;
    protected TableHelper tArtistGroup;
    protected TableHelper tArtGroup;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, 12, -5, 3});
        this.tPaintingInfo = new TableHelper(this.dbHelper, "PAINTING_INFO");
        this.tPaintingInfo.setColumns(new String[]{"PAINTING_ID", "TEXT_REVIEW"});
        this.tExhibit = new TableHelper(this.dbHelper, "EXHIBIT");
        this.tExhibit.setColumns(new String[]{"EXHIBIT_ID", "GALLERY_ID", "OPENING_DATE", "CLOSING_DATE"});
        this.tArtistExhibit = new TableHelper(this.dbHelper, "ARTIST_EXHIBIT");
        this.tArtistExhibit.setColumns(new String[]{"ARTIST_ID", "EXHIBIT_ID"});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        this.tArtistGroup = new TableHelper(this.dbHelper, "ARTIST_GROUP");
        this.tArtistGroup.setColumns(new String[]{"ARTIST_ID", "GROUP_ID"});
        this.tArtGroup = new TableHelper(this.dbHelper, "ARTGROUP");
        this.tArtGroup.setColumns(new String[]{"GROUP_ID", "NAME"});
    }

    protected void createTwoArtistsAndTwoPaintingsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tPainting.insert(new Object[]{6, "p_artist3", 101, 1000});
        this.tPainting.insert(new Object[]{7, "p_artist2", 11, 2000});
    }

    protected void createArtistWithTwoPaintingsAndTwoInfosDataSet() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tPainting.insert(new Object[]{6, "p_artist2", 11, 1000});
        this.tPainting.insert(new Object[]{7, "p_artist3", 11, 2000});
        this.tPaintingInfo.insert(new Object[]{6, "xYs"});
    }

    protected void createTwoArtistsWithExhibitsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tGallery.insert(new Object[]{25, "gallery1"});
        this.tGallery.insert(new Object[]{31, "gallery2"});
        this.tGallery.insert(new Object[]{45, "gallery3"});
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.tExhibit.insert(new Object[]{1, 25, now, now});
        this.tExhibit.insert(new Object[]{2, 31, now, now});
        this.tExhibit.insert(new Object[]{3, 45, now, now});
        this.tExhibit.insert(new Object[]{4, 25, now, now});
        this.tArtistExhibit.insert(new Object[]{11, 2});
        this.tArtistExhibit.insert(new Object[]{11, 4});
        this.tArtistExhibit.insert(new Object[]{101, 1});
        this.tArtistExhibit.insert(new Object[]{101, 3});
        this.tArtistExhibit.insert(new Object[]{101, 4});
    }

    @Test
    public void testPrefetchToMany_ViaProperty() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addPrefetch(Artist.PAINTING_ARRAY.disjoint());
        final List<Artist> artists = this.context.select(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)artists.size());
                for (int i = 0; i < 2; ++i) {
                    Artist a = (Artist)artists.get(i);
                    List toMany = (List)a.readPropertyDirectly("paintingArray");
                    Assert.assertNotNull((Object)toMany);
                    Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                    Assert.assertEquals((long)1L, (long)toMany.size());
                    Painting p = (Painting)toMany.get(0);
                    Assert.assertEquals((String)("Invalid prefetched painting:" + p), (Object)("p_" + a.getArtistName()), (Object)p.getPaintingTitle());
                }
            }
        });
    }

    @Test
    public void testPrefetchToMany_WithQualfier() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name1", "artist2");
        params.put("name2", "artist3");
        Expression e = ExpressionFactory.exp("artistName = $name1 or artistName = $name2", new Object[0]);
        SelectQuery q = new SelectQuery("Artist", e.params(params));
        q.addPrefetch(Artist.PAINTING_ARRAY.disjoint());
        final List artists = this.context.select(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)artists.size());
                Artist a1 = (Artist)artists.get(0);
                List toMany = (List)a1.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
                Assert.assertNotNull((Object)toMany);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                Assert.assertEquals((long)1L, (long)toMany.size());
                Painting p1 = (Painting)toMany.get(0);
                Assert.assertEquals((Object)("p_" + a1.getArtistName()), (Object)p1.getPaintingTitle());
                Artist a2 = (Artist)artists.get(1);
                List toMany2 = (List)a2.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
                Assert.assertNotNull((Object)toMany2);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany2)).isFault());
                Assert.assertEquals((long)1L, (long)toMany2.size());
                Painting p2 = (Painting)toMany2.get(0);
                Assert.assertEquals((Object)("p_" + a2.getArtistName()), (Object)p2.getPaintingTitle());
            }
        });
    }

    @Test
    public void testPrefetchToManyNoQualifier() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addPrefetch(Artist.PAINTING_ARRAY.disjoint());
        final List artists = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)artists.size());
                for (int i = 0; i < 2; ++i) {
                    Artist a = (Artist)artists.get(i);
                    List toMany = (List)a.readPropertyDirectly("paintingArray");
                    Assert.assertNotNull((Object)toMany);
                    Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                    Assert.assertEquals((long)1L, (long)toMany.size());
                    Painting p = (Painting)toMany.get(0);
                    Assert.assertEquals((String)("Invalid prefetched painting:" + p), (Object)("p_" + a.getArtistName()), (Object)p.getPaintingTitle());
                }
            }
        });
    }

    @Test
    public void testPrefetchToMany_OnJoinTableDisjoinedPrefetch() throws Exception {
        this.createTwoArtistsWithExhibitsDataSet();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addPrefetch(Artist.ARTIST_EXHIBIT_ARRAY.disjoint());
        q.addOrdering(Artist.ARTIST_NAME.asc());
        final List artists = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)artists.size());
                Artist a1 = (Artist)artists.get(0);
                Assert.assertEquals((Object)"artist2", (Object)a1.getArtistName());
                List toMany = (List)a1.readPropertyDirectly(Artist.ARTIST_EXHIBIT_ARRAY.getName());
                Assert.assertNotNull((Object)toMany);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                Assert.assertEquals((long)2L, (long)toMany.size());
                ArtistExhibit artistExhibit = (ArtistExhibit)toMany.get(0);
                Assert.assertEquals((long)3L, (long)artistExhibit.getPersistenceState());
                Assert.assertSame((Object)a1, (Object)artistExhibit.getToArtist());
                Artist a2 = (Artist)artists.get(1);
                Assert.assertEquals((Object)"artist3", (Object)a2.getArtistName());
                List toMany2 = (List)a2.readPropertyDirectly(Artist.ARTIST_EXHIBIT_ARRAY.getName());
                Assert.assertNotNull((Object)toMany2);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany2)).isFault());
                Assert.assertEquals((long)3L, (long)toMany2.size());
                ArtistExhibit artistExhibit2 = (ArtistExhibit)toMany2.get(0);
                Assert.assertEquals((long)3L, (long)artistExhibit2.getPersistenceState());
                Assert.assertSame((Object)a2, (Object)artistExhibit2.getToArtist());
            }
        });
    }

    @Test
    public void testPrefetchToManyOnJoinTableJoinedPrefetch_ViaProperty() throws Exception {
        this.createTwoArtistsWithExhibitsDataSet();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addPrefetch(Artist.ARTIST_EXHIBIT_ARRAY.joint());
        q.addOrdering(Artist.ARTIST_NAME.asc());
        final List<Artist> artists = this.context.select(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)artists.size());
                Artist a1 = (Artist)artists.get(0);
                Assert.assertEquals((Object)"artist2", (Object)a1.getArtistName());
                List toMany = (List)a1.readPropertyDirectly(Artist.ARTIST_EXHIBIT_ARRAY.getName());
                Assert.assertNotNull((Object)toMany);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                Assert.assertEquals((long)2L, (long)toMany.size());
                ArtistExhibit artistExhibit = (ArtistExhibit)toMany.get(0);
                Assert.assertEquals((long)3L, (long)artistExhibit.getPersistenceState());
                Assert.assertSame((Object)a1, (Object)artistExhibit.getToArtist());
                Artist a2 = (Artist)artists.get(1);
                Assert.assertEquals((Object)"artist3", (Object)a2.getArtistName());
                List toMany2 = (List)a2.readPropertyDirectly(Artist.ARTIST_EXHIBIT_ARRAY.getName());
                Assert.assertNotNull((Object)toMany2);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany2)).isFault());
                Assert.assertEquals((long)3L, (long)toMany2.size());
                ArtistExhibit artistExhibit2 = (ArtistExhibit)toMany2.get(0);
                Assert.assertEquals((long)3L, (long)artistExhibit2.getPersistenceState());
                Assert.assertSame((Object)a2, (Object)artistExhibit2.getToArtist());
            }
        });
    }

    @Test
    public void testPrefetchToManyOnJoinTableJoinedPrefetch() throws Exception {
        this.createTwoArtistsWithExhibitsDataSet();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addPrefetch(Artist.ARTIST_EXHIBIT_ARRAY.joint());
        q.addOrdering(Artist.ARTIST_NAME.asc());
        final List artists = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)artists.size());
                Artist a1 = (Artist)artists.get(0);
                Assert.assertEquals((Object)"artist2", (Object)a1.getArtistName());
                List toMany = (List)a1.readPropertyDirectly("artistExhibitArray");
                Assert.assertNotNull((Object)toMany);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                Assert.assertEquals((long)2L, (long)toMany.size());
                ArtistExhibit artistExhibit = (ArtistExhibit)toMany.get(0);
                Assert.assertEquals((long)3L, (long)artistExhibit.getPersistenceState());
                Assert.assertSame((Object)a1, (Object)artistExhibit.getToArtist());
                Artist a2 = (Artist)artists.get(1);
                Assert.assertEquals((Object)"artist3", (Object)a2.getArtistName());
                List toMany2 = (List)a2.readPropertyDirectly(Artist.ARTIST_EXHIBIT_ARRAY.getName());
                Assert.assertNotNull((Object)toMany2);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany2)).isFault());
                Assert.assertEquals((long)3L, (long)toMany2.size());
                ArtistExhibit artistExhibit2 = (ArtistExhibit)toMany2.get(0);
                Assert.assertEquals((long)3L, (long)artistExhibit2.getPersistenceState());
                Assert.assertSame((Object)a2, (Object)artistExhibit2.getToArtist());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrefetch_ToManyNoReverse() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjEntity paintingEntity = this.context.getEntityResolver().getObjEntity(Painting.class);
        ObjRelationship relationship = paintingEntity.getRelationship("toArtist");
        paintingEntity.removeRelationship("toArtist");
        try {
            SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
            q.addPrefetch(Artist.PAINTING_ARRAY.disjoint());
            final List result = this.context.performQuery(q);
            this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

                @Override
                public void execute() {
                    Assert.assertFalse((boolean)result.isEmpty());
                    Artist a1 = (Artist)result.get(0);
                    List toMany = (List)a1.readPropertyDirectly("paintingArray");
                    Assert.assertNotNull((Object)toMany);
                    Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                }
            });
        }
        finally {
            paintingEntity.addRelationship(relationship);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrefetch_ToManyNoReverseWithQualifier() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjEntity paintingEntity = this.context.getEntityResolver().getObjEntity(Painting.class);
        ObjRelationship relationship = paintingEntity.getRelationship("toArtist");
        paintingEntity.removeRelationship("toArtist");
        try {
            SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
            q.setQualifier(ExpressionFactory.matchExp("artistName", (Object)"artist2"));
            q.addPrefetch(Artist.PAINTING_ARRAY.disjoint());
            final List result = this.context.performQuery(q);
            this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

                @Override
                public void execute() {
                    Assert.assertFalse((boolean)result.isEmpty());
                    Artist a1 = (Artist)result.get(0);
                    List toMany = (List)a1.readPropertyDirectly("paintingArray");
                    Assert.assertNotNull((Object)toMany);
                    Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                }
            });
        }
        finally {
            paintingEntity.addRelationship(relationship);
        }
    }

    @Test
    public void testPrefetch_ToOne() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addPrefetch(Painting.TO_ARTIST.disjoint());
        final List result = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertFalse((boolean)result.isEmpty());
                Painting p1 = (Painting)result.get(0);
                Object toOnePrefetch = p1.readNestedProperty("toArtist");
                Assert.assertNotNull((Object)toOnePrefetch);
                Assert.assertTrue((String)("Expected Artist, got: " + toOnePrefetch.getClass().getName()), (boolean)(toOnePrefetch instanceof Artist));
                Artist a1 = (Artist)toOnePrefetch;
                Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
            }
        });
    }

    @Test
    public void testPrefetch_ToOne_DbPath() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addPrefetch(Painting.TO_ARTIST.disjoint());
        q.andQualifier(ExpressionFactory.matchDbExp("toArtist.ARTIST_NAME", "artist2"));
        List results = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testPrefetch_ToOne_ObjPath() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addPrefetch(Painting.TO_ARTIST.disjoint());
        q.andQualifier(ExpressionFactory.matchExp("toArtist.artistName", (Object)"artist2"));
        List results = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testPrefetch_ReflexiveRelationship() throws Exception {
        ArtGroup parent = (ArtGroup)this.context.newObject("ArtGroup");
        parent.setName("parent");
        ArtGroup child = (ArtGroup)this.context.newObject("ArtGroup");
        child.setName("child");
        child.setToParentGroup(parent);
        this.context.commitChanges();
        SelectQuery q = new SelectQuery("ArtGroup");
        q.setQualifier(ExpressionFactory.matchExp("name", (Object)"child"));
        q.addPrefetch("toParentGroup");
        final List results = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)1L, (long)results.size());
                ArtGroup fetchedChild = (ArtGroup)results.get(0);
                Assert.assertEquals((long)3L, (long)fetchedChild.getToParentGroup().getPersistenceState());
            }
        });
        child.setToParentGroup(null);
        this.context.commitChanges();
    }

    @Test
    public void testPrefetch_ToOneWithQualifierOverlappingPrefetchPath() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        Expression exp = ExpressionFactory.matchExp("toArtist.artistName", (Object)"artist3");
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class, exp);
        q.addPrefetch(Painting.TO_ARTIST.disjoint());
        final List results = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)1L, (long)results.size());
                Painting painting = (Painting)results.get(0);
                Assert.assertEquals((long)3L, (long)painting.getToArtist().getPersistenceState());
            }
        });
    }

    @Test
    public void testPrefetch_ToOneWith_OuterJoinFlattenedQualifier() throws Exception {
        this.tArtGroup.insert(new Object[]{1, "AG"});
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tPainting.insert(new Object[]{6, "p_artist3", 101, 1000});
        this.tPainting.insert(new Object[]{7, "p_artist21", 11, 2000});
        this.tPainting.insert(new Object[]{8, "p_artist22", 11, 3000});
        this.tArtistGroup.insert(new Object[]{101, 1});
        Expression exp = Property.create("groupArray+.name", String.class).eq("XX").orExp(Artist.ARTIST_NAME.eq("artist2"));
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, exp);
        q.addPrefetch(Artist.PAINTING_ARRAY.disjoint());
        final List<Artist> results = this.context.select(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)1L, (long)results.size());
                Artist a = (Artist)results.get(0);
                Assert.assertEquals((Object)"artist2", (Object)a.getArtistName());
                Assert.assertEquals((long)2L, (long)a.getPaintingArray().size());
            }
        });
    }

    @Test
    public void testPrefetch9() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        Expression artistExp = ExpressionFactory.matchExp("artistName", (Object)"artist3");
        SelectQuery<Artist> artistQuery = new SelectQuery<Artist>(Artist.class, artistExp);
        Artist artist1 = (Artist)this.context.performQuery(artistQuery).get(0);
        Expression exp = ExpressionFactory.noMatchExp("toArtist", (Object)artist1);
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class, exp);
        q.addPrefetch("toArtist");
        final List results = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)1L, (long)results.size());
                Painting px = (Painting)results.get(0);
                Artist ax = (Artist)px.readProperty(Painting.TO_ARTIST.getName());
                Assert.assertEquals((long)3L, (long)ax.getPersistenceState());
            }
        });
    }

    @Test
    public void testPrefetch_OneToOneWithQualifier() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        Expression e = ExpressionFactory.likeExp("toArtist.artistName", (Object)"a%");
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class, e);
        q.addPrefetch(Painting.TO_PAINTING_INFO.disjoint());
        q.addOrdering(Painting.PAINTING_TITLE.asc());
        final List results = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)results.size());
                Painting p0 = (Painting)results.get(0);
                Object o2 = p0.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName());
                Assert.assertTrue((boolean)(o2 instanceof PaintingInfo));
                PaintingInfo pi2 = (PaintingInfo)o2;
                Assert.assertEquals((long)3L, (long)pi2.getPersistenceState());
                Assert.assertEquals((long)Cayenne.intPKForObject(p0), (long)Cayenne.intPKForObject(pi2));
                Painting p1 = (Painting)results.get(1);
                Assert.assertNull((Object)p1.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName()));
                Assert.assertEquals((long)3L, (long)p1.getPersistenceState());
            }
        });
    }

    @Test
    public void testPrefetchToMany_DateInQualifier() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        Expression e = ExpressionFactory.matchExp("dateOfBirth", (Object)new Date());
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, e);
        q.addPrefetch("paintingArray");
        this.context.performQuery(q);
    }

    @Test
    public void testPrefetchingToOneNull() throws Exception {
        this.tPainting.insert(new Object[]{6, "p_Xty", null, 1000});
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addPrefetch(Painting.TO_ARTIST.disjoint());
        final List paintings = this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)1L, (long)paintings.size());
                Painting p2 = (Painting)paintings.get(0);
                Assert.assertNull((Object)p2.readProperty(Painting.TO_ARTIST.getName()));
            }
        });
    }

    @Test
    public void testPrefetchToOneSharedCache() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        final SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addPrefetch(Painting.TO_ARTIST.disjoint());
        q.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                List cachedResult = DataContextPrefetchIT.this.context.performQuery(q);
                Assert.assertFalse((boolean)cachedResult.isEmpty());
                Painting p1 = (Painting)cachedResult.get(0);
                Object toOnePrefetch = p1.readNestedProperty("toArtist");
                Assert.assertNotNull((Object)toOnePrefetch);
                Assert.assertTrue((String)("Expected Artist, got: " + toOnePrefetch.getClass().getName()), (boolean)(toOnePrefetch instanceof Artist));
                Artist a1 = (Artist)toOnePrefetch;
                Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
                DataContextPrefetchIT.this.context.performQuery(q);
            }
        });
    }

    @Test
    public void testPrefetchToOneLocalCache() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        final SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addPrefetch(Painting.TO_ARTIST.disjoint());
        q.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        this.context.performQuery(q);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                List cachedResult = DataContextPrefetchIT.this.context.performQuery(q);
                Assert.assertFalse((boolean)cachedResult.isEmpty());
                Painting p1 = (Painting)cachedResult.get(0);
                Object toOnePrefetch = p1.readNestedProperty("toArtist");
                Assert.assertNotNull((Object)toOnePrefetch);
                Assert.assertTrue((String)("Expected Artist, got: " + toOnePrefetch.getClass().getName()), (boolean)(toOnePrefetch instanceof Artist));
                Artist a1 = (Artist)toOnePrefetch;
                Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
                DataContextPrefetchIT.this.context.performQuery(q);
            }
        });
    }

    @Test
    public void testPrefetchToOneWithBackRelationship() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.andQualifier(Painting.PAINTING_TITLE.eq("p_artist2"));
        query.addPrefetch(Painting.TO_PAINTING_INFO.disjoint());
        query.addPrefetch(Painting.TO_PAINTING_INFO.dot(PaintingInfo.PAINTING).disjoint());
        final List<Painting> results = this.context.select(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)1L, (long)results.size());
                Painting p0 = (Painting)results.get(0);
                PaintingInfo pi0 = (PaintingInfo)p0.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName());
                Assert.assertNotNull((Object)pi0);
                Assert.assertNotNull((Object)pi0.readPropertyDirectly(PaintingInfo.PAINTING.getName()));
            }
        });
    }

    @Test
    public void testPrefetchPaintingOverToOneAndToMany() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.andQualifier(Painting.PAINTING_TITLE.eq("p_artist2"));
        query.addPrefetch(Painting.TO_ARTIST.disjoint());
        query.addPrefetch(Painting.TO_ARTIST.dot(Artist.PAINTING_ARRAY).disjoint());
        final List<Painting> results = this.context.select(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)1L, (long)results.size());
                Painting p0 = (Painting)results.get(0);
                Artist a0 = (Artist)p0.readPropertyDirectly(Painting.TO_ARTIST.getName());
                Assert.assertNotNull((Object)a0);
                List paintings = (List)a0.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
                Assert.assertEquals((long)2L, (long)paintings.size());
            }
        });
    }

    @Test
    public void testPrefetchToOneWithBackRelationship_Joint() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.andQualifier(Painting.PAINTING_TITLE.eq("p_artist2"));
        query.addPrefetch(Painting.TO_PAINTING_INFO.joint());
        query.addPrefetch(Painting.TO_PAINTING_INFO.dot(PaintingInfo.PAINTING).joint());
        final List<Painting> results = this.context.select(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)1L, (long)results.size());
                Painting p0 = (Painting)results.get(0);
                PaintingInfo pi0 = (PaintingInfo)p0.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName());
                Assert.assertNotNull((Object)pi0);
                Assert.assertNotNull((Object)pi0.readPropertyDirectly(PaintingInfo.PAINTING.getName()));
            }
        });
    }

    @Test
    public void testPrefetchJointAndDisjointByIdTogether() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.andQualifier(Painting.PAINTING_TITLE.eq("p_artist2"));
        query.addPrefetch(Painting.TO_ARTIST.joint());
        query.addPrefetch(Painting.TO_PAINTING_INFO.disjointById());
        final List<Painting> results = this.context.select(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)1L, (long)results.size());
                Painting p0 = (Painting)results.get(0);
                Artist a0 = (Artist)p0.readPropertyDirectly(Painting.TO_ARTIST.getName());
                Assert.assertNotNull((Object)a0);
                PaintingInfo info = (PaintingInfo)p0.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName());
                Assert.assertNotNull((Object)info);
            }
        });
    }
}

