/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashMap;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class DataContextEJBQLUpdateCompoundIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tCompoundPk;
    private TableHelper tCompoundFk;

    @Before
    public void setUp() throws Exception {
        this.tCompoundPk = new TableHelper(this.dbHelper, "COMPOUND_PK_TEST");
        this.tCompoundPk.setColumns(new String[]{"KEY1", "KEY2"});
        this.tCompoundFk = new TableHelper(this.dbHelper, "COMPOUND_FK_TEST");
        this.tCompoundFk.setColumns(new String[]{"PKEY", "F_KEY1", "F_KEY2"});
    }

    private void createTwoCompoundPKTwoFK() throws Exception {
        this.tCompoundPk.insert(new Object[]{"a1", "a2"});
        this.tCompoundPk.insert(new Object[]{"b1", "b2"});
        this.tCompoundFk.insert(new Object[]{33001, "a1", "a2"});
        this.tCompoundFk.insert(new Object[]{33002, "b1", "b2"});
    }

    @Test
    public void testUpdateNoQualifierToOneCompoundPK() throws Exception {
        this.createTwoCompoundPKTwoFK();
        HashMap<String, String> key1 = new HashMap<String, String>();
        key1.put("KEY1", "b1");
        key1.put("KEY2", "b2");
        CompoundPkTestEntity object = Cayenne.objectForPK(this.context, CompoundPkTestEntity.class, key1);
        EJBQLQuery check = new EJBQLQuery("select count(e) from CompoundFkTestEntity e WHERE e.toCompoundPk <> :param");
        check.setParameter("param", (Object)object);
        Object notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(1L), (Object)notUpdated);
        String ejbql = "UPDATE CompoundFkTestEntity e SET e.toCompoundPk = :param";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("param", (Object)object);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)2L, (long)count[0]);
        notUpdated = Cayenne.objectForQuery(this.context, check);
        Assert.assertEquals((Object)new Long(0L), (Object)notUpdated);
    }
}

