/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.cay_2032.Team;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-cay-2032.xml")
public class Cay2032IT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void createTestData() throws Exception {
        TableHelper tUser = new TableHelper(this.dbHelper, "USERS");
        tUser.setColumns(new String[]{"user_id"});
        tUser.insert(new Object[]{1});
        tUser.insert(new Object[]{2});
        tUser.insert(new Object[]{3});
        TableHelper tTeam = new TableHelper(this.dbHelper, "TEAM");
        tTeam.setColumns(new String[]{"team_id"});
        tTeam.insert(new Object[]{1});
        tTeam.insert(new Object[]{2});
        tTeam.insert(new Object[]{3});
        tTeam.insert(new Object[]{4});
        TableHelper tTeamHasUser = new TableHelper(this.dbHelper, "USER_HAS_TEAM");
        tTeamHasUser.setColumns(new String[]{"team_id", "user_id"});
        tTeamHasUser.insert(new Object[]{1, 2});
        tTeamHasUser.insert(new Object[]{2, 1});
        tTeamHasUser.insert(new Object[]{2, 2});
        tTeamHasUser.insert(new Object[]{2, 3});
        tTeamHasUser.insert(new Object[]{3, 1});
        tTeamHasUser.insert(new Object[]{3, 3});
    }

    private void checkResult(List<Team> result) throws Exception {
        Assert.assertNotNull(result);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((long)1L, (long)result.get(0).getTeamUsers().size());
        Assert.assertEquals((long)3L, (long)result.get(1).getTeamUsers().size());
        Assert.assertEquals((long)2L, (long)result.get(2).getTeamUsers().size());
        Assert.assertEquals((long)0L, (long)result.get(3).getTeamUsers().size());
    }

    @Test
    public void testPrefetchDisjoint() throws Exception {
        List<Team> result = ObjectSelect.query(Team.class).prefetch(Team.TEAM_USERS.disjoint()).orderBy("db:team_id", SortOrder.ASCENDING).select(this.context);
        this.checkResult(result);
    }

    @Test
    public void testPrefetchDisjointById() throws Exception {
        List<Team> result = ObjectSelect.query(Team.class).prefetch(Team.TEAM_USERS.disjointById()).orderBy("db:team_id", SortOrder.ASCENDING).select(this.context);
        this.checkResult(result);
    }

    @Test
    public void testPrefetchJoint() throws Exception {
        List<Team> result = ObjectSelect.query(Team.class).prefetch(Team.TEAM_USERS.joint()).orderBy("db:team_id", SortOrder.ASCENDING).select(this.context);
        this.checkResult(result);
    }
}

