/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.MockBaseContext;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BaseContextTest {
    @Test
    public void testUserPropertiesLazyInit() {
        MockBaseContext context = new MockBaseContext();
        Assert.assertNull(context.userProperties);
        Map<String, Object> properties = context.getUserProperties();
        Assert.assertNotNull(properties);
        Assert.assertSame(properties, context.getUserProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttachToRuntimeIfNeeded() {
        final DataChannel channel = (DataChannel)Mockito.mock(DataChannel.class);
        final QueryCache cache = (QueryCache)Mockito.mock(QueryCache.class);
        Module testModule = new Module(){

            public void configure(Binder binder) {
                binder.bind(DataChannel.class).toInstance((Object)channel);
                binder.bind(QueryCache.class).toInstance((Object)cache);
            }
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        MockBaseContext context = new MockBaseContext();
        Assert.assertNull((Object)context.channel);
        Assert.assertNull((Object)context.queryCache);
        Injector oldInjector = CayenneRuntime.getThreadInjector();
        try {
            CayenneRuntime.bindThreadInjector(injector);
            Assert.assertTrue((boolean)context.attachToRuntimeIfNeeded());
            Assert.assertSame((Object)channel, (Object)context.channel);
            Assert.assertFalse((boolean)context.attachToRuntimeIfNeeded());
            Assert.assertFalse((boolean)context.attachToRuntimeIfNeeded());
        }
        finally {
            CayenneRuntime.bindThreadInjector(oldInjector);
        }
    }

    @Test
    public void testAttachToRuntimeIfNeeded_NoStack() {
        MockBaseContext context = new MockBaseContext();
        Assert.assertNull((Object)context.channel);
        Assert.assertNull((Object)context.queryCache);
        try {
            context.attachToRuntimeIfNeeded();
            Assert.fail((String)"No thread stack, must have thrown");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }
}

