/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.exp.parser.ASTExtract;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.testdo.date_time.DateTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-date-time.xml")
public class ASTExtractIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter unitDbAdapter;

    @Before
    public void createDataSet() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        DateTestEntity o1 = this.context.newObject(DateTestEntity.class);
        cal.set(2015, 1, 28, 0, 0, 0);
        o1.setDateColumn(cal.getTime());
        cal.set(2017, 2, 30, 0, 0, 0);
        o1.setTimeColumn(cal.getTime());
        cal.set(5, 29);
        o1.setTimestampColumn(cal.getTime());
        DateTestEntity o2 = this.context.newObject(DateTestEntity.class);
        cal.set(2016, 2, 29, 0, 0, 0);
        o2.setDateColumn(cal.getTime());
        cal.set(2017, 3, 1, 23, 59, 39);
        o2.setTimeColumn(cal.getTime());
        cal.set(5, 2);
        o2.setTimestampColumn(cal.getTime());
        this.context.commitChanges();
    }

    @Test
    public void testYear() {
        block2: {
            Expression exp = ExpressionFactory.exp("year(dateColumn) = 2015", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.YEAR)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testMonth() {
        block2: {
            Expression exp = ExpressionFactory.exp("month(dateColumn) = 3", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.MONTH)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testWeek() {
        block2: {
            Expression exp = ExpressionFactory.exp("week(dateColumn) in (13, 14)", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.WEEK)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testDayOfYear() {
        block2: {
            Expression exp = ExpressionFactory.exp("dayOfYear(dateColumn) in (59, 58)", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.DAY_OF_YEAR)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testDayOfYearSelect() {
        block2: {
            Property<Integer> dayOfYear = Property.create(FunctionExpressionFactory.yearExp(DateTestEntity.DATE_COLUMN.path()), Integer.class);
            try {
                List res = ObjectSelect.query(DateTestEntity.class).column(dayOfYear).select(this.context);
                Assert.assertEquals((long)2L, (long)res.size());
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.DAY_OF_YEAR)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testDay() {
        block2: {
            Expression exp = ExpressionFactory.exp("day(dateColumn) = 28", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.DAY)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testDayOfMonth() {
        block2: {
            Expression exp = ExpressionFactory.exp("dayOfMonth(dateColumn) = 28", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.DAY_OF_MONTH)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testDayOfWeek() {
        block2: {
            Expression exp = ExpressionFactory.exp("dayOfWeek(dateColumn) in (2, 3)", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.DAY_OF_WEEK)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testHour() {
        block2: {
            Expression exp = ExpressionFactory.exp("hour(timestampColumn) = 23", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.HOUR)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testMinute() {
        block2: {
            Expression exp = ExpressionFactory.exp("minute(timestampColumn) = 59", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.MINUTE)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testSecond() {
        block2: {
            Expression exp = ExpressionFactory.exp("second(timestampColumn) = 39", new Object[0]);
            try {
                long res = ObjectSelect.query(DateTestEntity.class, exp).selectCount(this.context);
                Assert.assertEquals((long)1L, (long)res);
            }
            catch (CayenneRuntimeException e) {
                if (!this.unitDbAdapter.supportsExtractPart(ASTExtract.DateTimePart.SECOND)) break block2;
                throw e;
            }
        }
    }
}

