/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTAbs;
import org.apache.cayenne.exp.parser.ASTAvg;
import org.apache.cayenne.exp.parser.ASTConcat;
import org.apache.cayenne.exp.parser.ASTCount;
import org.apache.cayenne.exp.parser.ASTCurrentDate;
import org.apache.cayenne.exp.parser.ASTCurrentTime;
import org.apache.cayenne.exp.parser.ASTCurrentTimestamp;
import org.apache.cayenne.exp.parser.ASTExtract;
import org.apache.cayenne.exp.parser.ASTLength;
import org.apache.cayenne.exp.parser.ASTLocate;
import org.apache.cayenne.exp.parser.ASTLower;
import org.apache.cayenne.exp.parser.ASTMax;
import org.apache.cayenne.exp.parser.ASTMin;
import org.apache.cayenne.exp.parser.ASTMod;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ASTSqrt;
import org.apache.cayenne.exp.parser.ASTSubstring;
import org.apache.cayenne.exp.parser.ASTSum;
import org.apache.cayenne.exp.parser.ASTTrim;
import org.apache.cayenne.exp.parser.ASTUpper;

public class FunctionExpressionFactory {
    public static Expression substringExp(Expression exp, int offset, int length) {
        return FunctionExpressionFactory.substringExp(exp, new ASTScalar((Object)offset), new ASTScalar((Object)length));
    }

    public static Expression substringExp(String path, int offset, int length) {
        return FunctionExpressionFactory.substringExp((Expression)new ASTObjPath(path), new ASTScalar((Object)offset), new ASTScalar((Object)length));
    }

    public static Expression substringExp(Expression exp, Expression offset, Expression length) {
        return new ASTSubstring(exp, offset, length);
    }

    public static Expression trimExp(Expression exp) {
        return new ASTTrim(exp);
    }

    public static Expression trimExp(String path) {
        return new ASTTrim(new ASTObjPath(path));
    }

    public static Expression lowerExp(Expression exp) {
        return new ASTLower(exp);
    }

    public static Expression lowerExp(String path) {
        return new ASTLower(new ASTObjPath(path));
    }

    public static Expression upperExp(Expression exp) {
        return new ASTUpper(exp);
    }

    public static Expression upperExp(String path) {
        return new ASTUpper(new ASTObjPath(path));
    }

    public static Expression lengthExp(Expression exp) {
        return new ASTLength(exp);
    }

    public static Expression lengthExp(String path) {
        return new ASTLength(new ASTObjPath(path));
    }

    public static Expression locateExp(String substring, Expression exp) {
        return FunctionExpressionFactory.locateExp(new ASTScalar(substring), exp);
    }

    public static Expression locateExp(String substring, String path) {
        return FunctionExpressionFactory.locateExp(new ASTScalar(substring), (Expression)new ASTObjPath(path));
    }

    public static Expression locateExp(Expression substring, Expression exp) {
        return new ASTLocate(substring, exp);
    }

    public static Expression absExp(Expression exp) {
        return new ASTAbs(exp);
    }

    public static Expression absExp(String path) {
        return new ASTAbs(new ASTObjPath(path));
    }

    public static Expression sqrtExp(Expression exp) {
        return new ASTSqrt(exp);
    }

    public static Expression sqrtExp(String path) {
        return new ASTSqrt(new ASTObjPath(path));
    }

    public static Expression modExp(Expression exp, Number number) {
        return FunctionExpressionFactory.modExp(exp, new ASTScalar(number));
    }

    public static Expression modExp(String path, Number number) {
        return FunctionExpressionFactory.modExp((Expression)new ASTObjPath(path), new ASTScalar(number));
    }

    public static Expression modExp(Expression exp, Expression number) {
        return new ASTMod(exp, number);
    }

    public static Expression concatExp(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return new ASTConcat(new Expression[0]);
        }
        return new ASTConcat(expressions);
    }

    public static Expression concatExp(String ... paths) {
        if (paths == null || paths.length == 0) {
            return new ASTConcat(new Expression[0]);
        }
        Expression[] expressions = new Expression[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            expressions[i] = new ASTObjPath(paths[i]);
        }
        return new ASTConcat(expressions);
    }

    public static Expression countExp() {
        return new ASTCount();
    }

    public static Expression countExp(Expression exp) {
        return new ASTCount(exp);
    }

    public static Expression minExp(Expression exp) {
        return new ASTMin(exp);
    }

    public static Expression maxExp(Expression exp) {
        return new ASTMax(exp);
    }

    public static Expression avgExp(Expression exp) {
        return new ASTAvg(exp);
    }

    public static Expression sumExp(Expression exp) {
        return new ASTSum(exp);
    }

    public static Expression currentDate() {
        return new ASTCurrentDate();
    }

    public static Expression currentTime() {
        return new ASTCurrentTime();
    }

    public static Expression currentTimestamp() {
        return new ASTCurrentTimestamp();
    }

    public static Expression yearExp(Expression exp) {
        return FunctionExpressionFactory.extractExp(exp, ASTExtract.DateTimePart.YEAR);
    }

    public static Expression yearExp(String path) {
        return FunctionExpressionFactory.extractExp(path, ASTExtract.DateTimePart.YEAR);
    }

    public static Expression monthExp(Expression exp) {
        return FunctionExpressionFactory.extractExp(exp, ASTExtract.DateTimePart.MONTH);
    }

    public static Expression monthExp(String path) {
        return FunctionExpressionFactory.extractExp(path, ASTExtract.DateTimePart.MONTH);
    }

    public static Expression weekExp(Expression exp) {
        return FunctionExpressionFactory.extractExp(exp, ASTExtract.DateTimePart.WEEK);
    }

    public static Expression weekExp(String path) {
        return FunctionExpressionFactory.extractExp(path, ASTExtract.DateTimePart.WEEK);
    }

    public static Expression dayOfYearExp(Expression exp) {
        return FunctionExpressionFactory.extractExp(exp, ASTExtract.DateTimePart.DAY_OF_YEAR);
    }

    public static Expression dayOfYearExp(String path) {
        return FunctionExpressionFactory.extractExp(path, ASTExtract.DateTimePart.DAY_OF_YEAR);
    }

    public static Expression dayOfMonthExp(Expression exp) {
        return FunctionExpressionFactory.extractExp(exp, ASTExtract.DateTimePart.DAY_OF_MONTH);
    }

    public static Expression dayOfMonthExp(String path) {
        return FunctionExpressionFactory.extractExp(path, ASTExtract.DateTimePart.DAY_OF_MONTH);
    }

    public static Expression dayOfWeekExp(Expression exp) {
        return FunctionExpressionFactory.extractExp(exp, ASTExtract.DateTimePart.DAY_OF_WEEK);
    }

    public static Expression dayOfWeekExp(String path) {
        return FunctionExpressionFactory.extractExp(path, ASTExtract.DateTimePart.DAY_OF_WEEK);
    }

    public static Expression hourExp(Expression exp) {
        return FunctionExpressionFactory.extractExp(exp, ASTExtract.DateTimePart.HOUR);
    }

    public static Expression hourExp(String path) {
        return FunctionExpressionFactory.extractExp(path, ASTExtract.DateTimePart.HOUR);
    }

    public static Expression minuteExp(Expression exp) {
        return FunctionExpressionFactory.extractExp(exp, ASTExtract.DateTimePart.MINUTE);
    }

    public static Expression minuteExp(String path) {
        return FunctionExpressionFactory.extractExp(path, ASTExtract.DateTimePart.MINUTE);
    }

    public static Expression secondExp(Expression exp) {
        return FunctionExpressionFactory.extractExp(exp, ASTExtract.DateTimePart.SECOND);
    }

    public static Expression secondExp(String path) {
        return FunctionExpressionFactory.extractExp(path, ASTExtract.DateTimePart.SECOND);
    }

    static Expression extractExp(String path, ASTExtract.DateTimePart part) {
        return FunctionExpressionFactory.extractExp(ExpressionFactory.pathExp(path), part);
    }

    static Expression extractExp(Expression exp, ASTExtract.DateTimePart part) {
        ASTExtract extract = new ASTExtract(exp);
        extract.setPart(part);
        return extract;
    }
}

