/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.util.Collections;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.dba.derby.DerbyPkGenerator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.SchemaBuilder;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class JdbcPkGeneratorIT
extends ServerCase {
    @Inject
    private DbAdapter adapter;
    @Inject
    private DataNode node;
    @Inject
    private SchemaBuilder schemaBuilder;

    @Before
    public void setUp() throws Exception {
        this.schemaBuilder.dropPKSupport();
    }

    @After
    public void tearDown() throws Exception {
        if (JdbcPkGenerator.class.isAssignableFrom(this.adapter.getPkGenerator().getClass())) {
            JdbcPkGenerator pkGenerator = (JdbcPkGenerator)this.adapter.getPkGenerator();
            pkGenerator.setPkStartValue(200L);
            this.schemaBuilder.dropPKSupport();
            this.schemaBuilder.createPKSupport();
        }
    }

    @Test
    public void testLongPk() throws Exception {
        if (!JdbcPkGenerator.class.isAssignableFrom(this.adapter.getPkGenerator().getClass())) {
            return;
        }
        DbEntity artistEntity = this.node.getEntityResolver().getObjEntity(Artist.class).getDbEntity();
        DbAttribute pkAttribute = artistEntity.getAttribute("ARTIST_ID");
        JdbcPkGenerator pkGenerator = (JdbcPkGenerator)this.adapter.getPkGenerator();
        pkGenerator.setPkStartValue(0xFFFFFFFEL);
        if (!JdbcPkGenerator.class.equals(this.adapter.getPkGenerator().getClass()) && !DerbyPkGenerator.class.equals(this.adapter.getPkGenerator().getClass())) {
            pkGenerator.dropAutoPk(this.node, Collections.singletonList(artistEntity));
        }
        pkGenerator.createAutoPk(this.node, Collections.singletonList(artistEntity));
        pkGenerator.reset();
        Object pk = pkGenerator.generatePk(this.node, pkAttribute);
        Assert.assertTrue((boolean)(pk instanceof Long));
        Assert.assertTrue((String)("PK is too small: " + pk), ((Long)pk > Integer.MAX_VALUE ? 1 : 0) != 0);
    }
}

