/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.cayenne.cache.OSQueryCache;
import org.apache.cayenne.query.MockQueryMetadata;
import org.junit.Assert;
import org.junit.Test;

public class OSQueryCacheTest {
    @Test
    public void testDefaults() {
        OSQueryCache cache = new OSQueryCache();
        Assert.assertNull(cache.refreshSpecifications);
        Assert.assertNull((Object)cache.defaultRefreshSpecification.cronExpression);
        Assert.assertEquals((long)-1L, (long)cache.defaultRefreshSpecification.refreshPeriod);
    }

    @Test
    public void testDefaultOverrides() {
        Properties props = new Properties();
        props.put(OSQueryCache.DEFAULT_REFRESH_KEY, "15");
        props.put(OSQueryCache.DEFAULT_CRON_KEY, "9 * * * * *");
        OSQueryCache cache = new OSQueryCache(new GeneralCacheAdministrator(), props);
        Assert.assertNull(cache.refreshSpecifications);
        Assert.assertEquals((Object)"9 * * * * *", (Object)cache.defaultRefreshSpecification.cronExpression);
        Assert.assertEquals((long)15L, (long)cache.defaultRefreshSpecification.refreshPeriod);
    }

    @Test
    public void testQueryOverrides() {
        Properties props = new Properties();
        props.put(OSQueryCache.GROUP_PREFIX + "ABC" + OSQueryCache.REFRESH_SUFFIX, "25");
        props.put(OSQueryCache.GROUP_PREFIX + "ABC" + OSQueryCache.CRON_SUFFIX, "12 * * * * *");
        props.put(OSQueryCache.GROUP_PREFIX + "XYZ" + OSQueryCache.REFRESH_SUFFIX, "35");
        props.put(OSQueryCache.GROUP_PREFIX + "XYZ" + OSQueryCache.CRON_SUFFIX, "24 * * * * *");
        OSQueryCache cache = new OSQueryCache(new GeneralCacheAdministrator(), props);
        Assert.assertNotNull(cache.refreshSpecifications);
        Assert.assertEquals((long)2L, (long)cache.refreshSpecifications.size());
        OSQueryCache.RefreshSpecification abc = cache.refreshSpecifications.get("ABC");
        Assert.assertNotNull((Object)abc);
        Assert.assertEquals((Object)"12 * * * * *", (Object)abc.cronExpression);
        Assert.assertEquals((long)25L, (long)abc.refreshPeriod);
        OSQueryCache.RefreshSpecification xyz = cache.refreshSpecifications.get("XYZ");
        Assert.assertNotNull((Object)xyz);
        Assert.assertEquals((Object)"24 * * * * *", (Object)xyz.cronExpression);
        Assert.assertEquals((long)35L, (long)xyz.refreshPeriod);
    }

    @Test
    public void testGroupNames() {
        Properties props = new Properties();
        OSQueryCache c1 = new OSQueryCache(new GeneralCacheAdministrator(), props);
        Assert.assertTrue((boolean)c1.getGroupNames().isEmpty());
        props.put(OSQueryCache.GROUP_PREFIX + "ABC" + OSQueryCache.REFRESH_SUFFIX, "25");
        props.put(OSQueryCache.GROUP_PREFIX + "XYZ" + OSQueryCache.CRON_SUFFIX, "24 * * * * *");
        OSQueryCache c2 = new OSQueryCache(new GeneralCacheAdministrator(), props);
        Assert.assertEquals((long)2L, (long)c2.getGroupNames().size());
        Assert.assertTrue((boolean)c2.getGroupNames().contains("ABC"));
        Assert.assertTrue((boolean)c2.getGroupNames().contains("XYZ"));
    }

    @Test
    public void testSize() {
        OSQueryCache cache = new OSQueryCache();
        ArrayList r1 = new ArrayList();
        MockQueryMetadata m1 = new MockQueryMetadata(){

            @Override
            public String getCacheKey() {
                return "a";
            }
        };
        cache.put(m1, r1);
        Assert.assertEquals((long)1L, (long)cache.size());
        ArrayList r2 = new ArrayList();
        MockQueryMetadata m2 = new MockQueryMetadata(){

            @Override
            public String getCacheKey() {
                return "b";
            }
        };
        cache.put(m2, r2);
        Assert.assertEquals((long)2L, (long)cache.size());
    }
}

