/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.CacheManager;
import org.apache.cayenne.cache.EhCacheQueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.query.QueryMetadata;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class EhCacheQueryCacheTest {
    private CacheManager cacheManager;

    @Before
    public void setUp() throws Exception {
        this.cacheManager = new CacheManager();
    }

    @After
    public void tearDown() throws Exception {
        this.cacheManager.shutdown();
    }

    @Test
    public void testGet() {
        EhCacheQueryCache cache = new EhCacheQueryCache(this.cacheManager);
        QueryMetadata md = (QueryMetadata)Mockito.mock(QueryMetadata.class);
        Mockito.when((Object)md.getCacheKey()).thenReturn((Object)"k1");
        Assert.assertNull((Object)cache.get(md));
        ArrayList results = new ArrayList();
        cache.put(md, results);
        Assert.assertSame(results, (Object)cache.get(md));
    }

    @Test
    public void testGet_WithFactory() {
        EhCacheQueryCache cache = new EhCacheQueryCache(this.cacheManager);
        ArrayList[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        QueryCacheEntryFactory factory = (QueryCacheEntryFactory)Mockito.mock(QueryCacheEntryFactory.class);
        Mockito.when((Object)factory.createObject()).thenReturn((Object)lists[0], (Object[])new List[]{lists[1], lists[2]});
        QueryMetadata md = (QueryMetadata)Mockito.mock(QueryMetadata.class);
        Mockito.when((Object)md.getCacheKey()).thenReturn((Object)"k1");
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        ArrayList results = new ArrayList();
        cache.put(md, results);
        Assert.assertSame(results, (Object)cache.get(md));
    }

    @Test
    public void testGet_WithFactory_WithCacheGroups() {
        EhCacheQueryCache cache = new EhCacheQueryCache(this.cacheManager);
        ArrayList[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        QueryCacheEntryFactory factory = (QueryCacheEntryFactory)Mockito.mock(QueryCacheEntryFactory.class);
        Mockito.when((Object)factory.createObject()).thenReturn((Object)lists[0], (Object[])new List[]{lists[1], lists[2]});
        QueryMetadata md = (QueryMetadata)Mockito.mock(QueryMetadata.class);
        Mockito.when((Object)md.getCacheKey()).thenReturn((Object)"k1");
        Mockito.when((Object)md.getCacheGroups()).thenReturn((Object)new String[]{"cg1"});
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        ArrayList results = new ArrayList();
        cache.put(md, results);
        Assert.assertSame(results, (Object)cache.get(md));
    }

    @Test
    public void testRemoveGroup_WithFactory_WithCacheGroups() {
        EhCacheQueryCache cache = new EhCacheQueryCache(this.cacheManager);
        ArrayList[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        QueryCacheEntryFactory factory = (QueryCacheEntryFactory)Mockito.mock(QueryCacheEntryFactory.class);
        Mockito.when((Object)factory.createObject()).thenReturn((Object)lists[0], (Object[])new List[]{lists[1], lists[2]});
        QueryMetadata md = (QueryMetadata)Mockito.mock(QueryMetadata.class);
        Mockito.when((Object)md.getCacheKey()).thenReturn((Object)"k1");
        Mockito.when((Object)md.getCacheGroups()).thenReturn((Object)new String[]{"cg1"});
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        cache.removeGroup("cg0");
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        cache.removeGroup("cg1");
        Assert.assertEquals((Object)lists[1], (Object)cache.get(md, factory));
    }
}

