/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.cayenne.access.types.DefaultValueObjectTypeRegistry;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.MockExtendedType;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ValueObjectTypeFactoryOrderTest {
    ExtendedTypeMap extendedTypeMap;
    ValueObjectType valueObjectType1;
    ValueObjectType valueObjectType2;
    ExtendedType tstType1;
    ExtendedType tstType2;

    @Before
    public void setUpRegistry() {
        this.valueObjectType1 = this.createMockValueType(UUID.class, byte[].class);
        this.valueObjectType2 = this.createMockValueType(UUID.class, String.class);
        this.extendedTypeMap = new ExtendedTypeMap();
        this.tstType1 = (ExtendedType)Mockito.mock(ExtendedType.class);
        Mockito.when((Object)this.tstType1.getClassName()).thenReturn((Object)"byte[]");
        this.extendedTypeMap.registerType(this.tstType1);
        this.tstType2 = new MockExtendedType(String.class);
        this.extendedTypeMap.registerType(this.tstType2);
    }

    private ValueObjectType createMockValueType(Class<?> valueClass, Class<?> targetClass) {
        ValueObjectType valueObjectType = (ValueObjectType)Mockito.mock(ValueObjectType.class);
        Mockito.when(valueObjectType.getValueType()).thenReturn(valueClass);
        Mockito.when(valueObjectType.getTargetType()).thenReturn(targetClass);
        return valueObjectType;
    }

    @Test
    public void testByteFirstOrder() {
        ArrayList list = new ArrayList();
        list.add(this.valueObjectType1);
        list.add(this.valueObjectType2);
        DefaultValueObjectTypeRegistry registry = new DefaultValueObjectTypeRegistry(list);
        ValueObjectTypeFactory factory = new ValueObjectTypeFactory(this.extendedTypeMap, registry);
        ValueObjectTypeFactory.ExtendedTypeConverter converter = (ValueObjectTypeFactory.ExtendedTypeConverter)factory.getType(UUID.class);
        Assert.assertNotNull((Object)converter);
        Assert.assertNotSame((Object)this.tstType1, converter.extendedType);
        Assert.assertSame((Object)this.tstType2, converter.extendedType);
    }

    @Test
    public void testStringFirstOrder() {
        ArrayList list = new ArrayList();
        list.add(this.valueObjectType2);
        list.add(this.valueObjectType1);
        DefaultValueObjectTypeRegistry registry = new DefaultValueObjectTypeRegistry(list);
        ValueObjectTypeFactory factory = new ValueObjectTypeFactory(this.extendedTypeMap, registry);
        ValueObjectTypeFactory.ExtendedTypeConverter converter = (ValueObjectTypeFactory.ExtendedTypeConverter)factory.getType(UUID.class);
        Assert.assertNotNull((Object)converter);
        Assert.assertNotSame((Object)this.tstType2, converter.extendedType);
        Assert.assertSame((Object)this.tstType1, converter.extendedType);
    }
}

