/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DeleteObjectIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID"});
    }

    protected void createHollowDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "artist1"});
        this.tPainting.insert(new Object[]{1, "painting1", 1});
    }

    protected void createObjectDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "artist1"});
    }

    protected void createObjectsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "artist1"});
        this.tArtist.insert(new Object[]{2, "artist2"});
    }

    protected void createObjectsRelationshipCollectionDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "artist1"});
        this.tPainting.insert(new Object[]{1, "painting1", 1});
        this.tPainting.insert(new Object[]{2, "painting2", 1});
        this.tPainting.insert(new Object[]{3, "painting3", 1});
    }

    @Test
    public void testDeleteObject() throws Exception {
        this.createObjectDataSet();
        Artist artist = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 1);
        Assert.assertEquals((long)3L, (long)artist.getPersistenceState());
        this.context.deleteObject(artist);
        Assert.assertEquals((long)6L, (long)artist.getPersistenceState());
        this.context.commitChanges();
        Assert.assertEquals((long)1L, (long)artist.getPersistenceState());
        Assert.assertNull((Object)artist.getObjectContext());
    }

    @Test
    public void testDeleteObjects1() throws Exception {
        this.createObjectsDataSet();
        List artists = this.context.performQuery(new SelectQuery<Artist>(Artist.class));
        Assert.assertEquals((long)2L, (long)artists.size());
        for (Artist object : artists) {
            Assert.assertEquals((long)3L, (long)object.getPersistenceState());
        }
        this.context.deleteObjects(artists);
        for (Artist object : artists) {
            Assert.assertEquals((long)6L, (long)object.getPersistenceState());
        }
    }

    @Test
    public void testDeleteObjects2() throws Exception {
        this.createObjectsDataSet();
        List artists = this.context.performQuery(new SelectQuery<Artist>(Artist.class));
        Assert.assertEquals((long)2L, (long)artists.size());
        for (Artist object : artists) {
            Assert.assertEquals((long)3L, (long)object.getPersistenceState());
        }
        ((Artist)artists.get(0)).getObjectContext().deleteObjects(artists);
        for (Artist object : artists) {
            Assert.assertEquals((long)6L, (long)object.getPersistenceState());
        }
        ((Artist)artists.get(0)).getObjectContext().commitChanges();
        for (Artist object : artists) {
            Assert.assertEquals((long)1L, (long)object.getPersistenceState());
        }
    }

    @Test
    public void testDeleteObjectsRelationshipCollection() throws Exception {
        this.createObjectsRelationshipCollectionDataSet();
        Artist artist = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 1);
        List<Painting> paintings = artist.getPaintingArray();
        Assert.assertEquals((long)3L, (long)paintings.size());
        ArrayList<Painting> paintingsClone = new ArrayList<Painting>(paintings);
        for (Painting object : paintingsClone) {
            Assert.assertEquals((long)3L, (long)object.getPersistenceState());
        }
        this.context.deleteObjects((Collection<?>)paintings);
        ObjRelationship r = this.context.getEntityResolver().getObjEntity(Painting.class).getRelationship("toArtist");
        Assert.assertEquals((long)1L, (long)r.getDeleteRule());
        Assert.assertEquals((long)0L, (long)paintings.size());
        for (Painting object : paintingsClone) {
            Assert.assertEquals((long)6L, (long)object.getPersistenceState());
        }
    }

    @Test
    public void testDeleteObjectInIterator() throws Exception {
        this.createObjectsRelationshipCollectionDataSet();
        Artist artist = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 1);
        List<Painting> paintings = artist.getPaintingArray();
        Assert.assertEquals((long)3L, (long)paintings.size());
        ArrayList<Painting> paintingsClone = new ArrayList<Painting>(paintings);
        for (Painting object : paintingsClone) {
            Assert.assertEquals((long)3L, (long)object.getPersistenceState());
        }
        Iterator<Painting> deleteIt = paintings.iterator();
        while (deleteIt.hasNext()) {
            Painting object;
            object = deleteIt.next();
            deleteIt.remove();
            this.context.deleteObjects(object);
        }
        Assert.assertEquals((long)0L, (long)paintings.size());
        for (Painting object : paintingsClone) {
            Assert.assertEquals((long)6L, (long)object.getPersistenceState());
        }
    }

    @Test
    public void testDeleteHollow() throws Exception {
        this.createHollowDataSet();
        List paintings = this.context.performQuery(new SelectQuery<Painting>(Painting.class));
        Painting p = (Painting)paintings.get(0);
        Artist a = p.getToArtist();
        Assert.assertEquals((long)5L, (long)a.getPersistenceState());
        this.context.deleteObjects(a);
        Assert.assertEquals((long)6L, (long)a.getPersistenceState());
    }

    @Test
    public void testDeleteNew() throws Exception {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("a");
        Assert.assertEquals((long)2L, (long)artist.getPersistenceState());
        this.context.deleteObjects(artist);
        Assert.assertEquals((long)1L, (long)artist.getPersistenceState());
        this.context.rollbackChanges();
        Assert.assertEquals((long)1L, (long)artist.getPersistenceState());
    }
}

