/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLDeleteIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected ServerRuntime runtime;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    protected void createPaintingsDataSet() throws Exception {
        this.tPainting.insert(new Object[]{33001, null, "P1", 3000});
        this.tPainting.insert(new Object[]{33002, null, "P2", 5000});
    }

    @Test
    public void testDeleteNoIdVar() throws Exception {
        this.createPaintingsDataSet();
        String ejbql = "delete from Painting";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)2L, (long)count[0]);
    }

    @Test
    public void testDeleteNoQualifier() throws Exception {
        this.createPaintingsDataSet();
        String ejbql = "delete from Painting AS p";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)2L, (long)count[0]);
    }

    @Test
    public void testDeleteSameEntityQualifier() throws Exception {
        this.createPaintingsDataSet();
        String ejbql = "delete from Painting AS p WHERE p.paintingTitle = 'P2'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)1L, (long)count[0]);
        ObjectContext freshContext = this.runtime.newContext();
        Assert.assertNotNull((Object)Cayenne.objectForPK(freshContext, Painting.class, 33001));
        Assert.assertNull((Object)Cayenne.objectForPK(freshContext, Painting.class, 33002));
    }
}

