/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.MockDataChannelFilter;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.testdo.relationships_many_to_many_join.Author;
import org.apache.cayenne.testdo.relationships_many_to_many_join.Song;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-many-to-many-join.xml")
public class ManyToManyJoinIT
extends ServerCase {
    @Inject
    private ServerRuntime serverRuntime;
    @Inject
    private ObjectContext context;

    @Test
    public void testManyToManyJoinWithFlattenedRelationship() {
        Author author = this.context.newObject(Author.class);
        author.setName("Bob Dylan");
        Song song = this.context.newObject(Song.class);
        song.setName("House of the Rising Sun");
        song.addToAuthors(author);
        this.context.commitChanges();
        Assert.assertEquals((Object)author, (Object)song.getAuthors().iterator().next());
    }

    @Test
    public void testManyToManyJoinWithFlattenedRelationshipEvents() {
        DataDomain domain = this.serverRuntime.getDataDomain();
        MockDataChannelFilter f1 = new MockDataChannelFilter(){

            @Override
            public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelFilterChain filterChain) {
                GraphDiff response = filterChain.onSync(originatingContext, changes, syncType);
                final AtomicInteger count = new AtomicInteger(0);
                changes.apply(new GraphChangeHandler(){

                    @Override
                    public void nodeIdChanged(Object nodeId, Object newId) {
                    }

                    @Override
                    public void nodeCreated(Object nodeId) {
                    }

                    @Override
                    public void nodeRemoved(Object nodeId) {
                    }

                    @Override
                    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
                    }

                    @Override
                    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
                        count.incrementAndGet();
                    }

                    @Override
                    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
                    }
                });
                Assert.assertEquals((long)1L, (long)count.get());
                return response;
            }
        };
        domain.addFilter(f1);
        Author author = this.context.newObject(Author.class);
        author.setName("Bob Dylan");
        Song song = this.context.newObject(Song.class);
        song.setName("House of the Rising Sun");
        song.addToAuthors(author);
        this.context.commitChanges();
    }
}

