/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.LimitResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLAction;

public abstract class BaseSQLAction
implements SQLAction {
    protected DataNode dataNode;

    public BaseSQLAction(DataNode dataNode) {
        this.dataNode = dataNode;
    }

    protected void readResultSet(ResultSet resultSet, RowDescriptor descriptor, Query query, OperationObserver delegate) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        QueryMetadata metadata = query.getMetaData(this.dataNode.getEntityResolver());
        RowReader<?> rowReader = this.dataNode.rowReader(descriptor, metadata);
        JDBCResultIterator resultReader = new JDBCResultIterator(null, resultSet, rowReader);
        LimitResultIterator it = new LimitResultIterator(resultReader, this.getInMemoryOffset(metadata.getFetchOffset()), metadata.getFetchLimit());
        if (!delegate.isIteratedResult()) {
            List<?> resultRows = it.allRows();
            this.dataNode.getJdbcEventLogger().logSelectCount(resultRows.size(), System.currentTimeMillis() - t1);
            delegate.nextRows(query, resultRows);
        } else {
            try {
                delegate.nextRows(query, it);
            }
            catch (Exception ex) {
                it.close();
                throw ex;
            }
        }
    }

    protected int getInMemoryOffset(int queryOffset) {
        return queryOffset;
    }
}

