/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.Date;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.MockQueryRouter;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SelectQueryIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void before() {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST").setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"}).setColumnTypes(new int[]{-5, 1, 91});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING").setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"}).setColumnTypes(new int[]{4, -5, 12});
    }

    protected void createArtistsDataSet() throws Exception {
        long dateBase = System.currentTimeMillis();
        for (int i = 1; i <= 20; ++i) {
            this.tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(10000 * i))});
        }
    }

    protected void createArtistsWildcardDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "_X", null});
        this.tArtist.insert(new Object[]{2, "Y_", null});
    }

    @Test
    public void testSelect_QualfierOnToMany() throws Exception {
        this.tArtist.insert(new Object[]{1, "A1", new Date(System.currentTimeMillis())});
        this.tPainting.insert(new Object[]{4, 1, "P1"});
        this.tPainting.insert(new Object[]{5, 1, "P2"});
        this.tPainting.insert(new Object[]{6, null, "P3"});
        List<Artist> objects = SelectQuery.query(Artist.class, Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).like("P%")).select(this.context);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testFetchLimit() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setFetchLimit(7);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)7L, (long)objects.size());
    }

    @Test
    public void testFetchOffset() throws Exception {
        this.createArtistsDataSet();
        int totalRows = new SelectQuery<Artist>(Artist.class).select(this.context).size();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering("db:ARTIST_ID", SortOrder.ASCENDING);
        query.setFetchOffset(5);
        List<Artist> results = this.context.select(query);
        Assert.assertEquals((long)(totalRows - 5), (long)results.size());
        Assert.assertEquals((Object)"artist6", (Object)results.get(0).getArtistName());
    }

    @Test
    public void testDbEntityRoot() throws Exception {
        this.createArtistsDataSet();
        DbEntity artistDbEntity = this.context.getEntityResolver().getDbEntity("ARTIST");
        SelectQuery query = new SelectQuery(artistDbEntity);
        List results = this.context.select(query);
        Assert.assertEquals((long)20L, (long)results.size());
        Assert.assertTrue((boolean)(results.get(0) instanceof DataRow));
    }

    @Test
    public void testFetchLimitWithOffset() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering("db:ARTIST_ID", SortOrder.ASCENDING);
        query.setFetchOffset(15);
        query.setFetchLimit(4);
        List<Artist> results = this.context.select(query);
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)"artist16", (Object)results.get(0).getArtistName());
    }

    @Test
    public void testFetchOffsetWithQualifier() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setQualifier(ExpressionFactory.exp("db:ARTIST_ID > 3", new Object[0]));
        query.setFetchOffset(5);
        List<Artist> objects = query.select(this.context);
        int size = objects.size();
        SelectQuery<Artist> sizeQ = new SelectQuery<Artist>(Artist.class);
        sizeQ.setQualifier(ExpressionFactory.exp("db:ARTIST_ID > 3", new Object[0]));
        List<Artist> objects1 = sizeQ.select(this.context);
        int sizeAll = objects1.size();
        Assert.assertEquals((long)size, (long)(sizeAll - 5));
    }

    @Test
    public void testFetchLimitWithQualifier() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setQualifier(ExpressionFactory.exp("db:ARTIST_ID > 3", new Object[0]));
        query.setFetchLimit(7);
        List<Artist> objects = query.select(this.context);
        Assert.assertEquals((long)7L, (long)objects.size());
    }

    @Test
    public void testSelectAllObjectsRootEntityName() throws Exception {
        this.createArtistsDataSet();
        SelectQuery query = new SelectQuery("Artist");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)20L, (long)objects.size());
    }

    @Test
    public void testSelectAllObjectsRootClass() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)20L, (long)objects.size());
    }

    @Test
    public void testSelectAllObjectsRootObjEntity() throws Exception {
        this.createArtistsDataSet();
        ObjEntity artistEntity = this.context.getEntityResolver().getObjEntity(Artist.class);
        SelectQuery query = new SelectQuery(artistEntity);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)20L, (long)objects.size());
    }

    @Test
    public void testSelectLikeExactMatch() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.likeExp("artistName", (Object)"artist1");
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testSelectNotLikeSingleWildcardMatch() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.notLikeExp("artistName", (Object)"artist11%");
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)19L, (long)objects.size());
    }

    @Test
    public void testSelectNotLikeIgnoreCaseSingleWildcardMatch() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.notLikeIgnoreCaseExp("artistName", (Object)"aRtIsT11%");
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)19L, (long)objects.size());
    }

    @Test
    public void testSelectLikeCaseSensitive() throws Exception {
        if (!this.accessStackAdapter.supportsCaseSensitiveLike()) {
            return;
        }
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.likeExp("artistName", (Object)"aRtIsT%");
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)0L, (long)objects.size());
    }

    @Test
    public void testSelectLikeSingle_WildcardMatch() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.likeExp("artistName", (Object)"artist11%");
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testSelectLikeSingle_WildcardMatchAndEscape() throws Exception {
        if (!this.accessStackAdapter.supportsEscapeInLike()) {
            return;
        }
        this.createArtistsWildcardDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.andQualifier(ExpressionFactory.likeExp("artistName", (Object)"=_%", '='));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testSelectLike_WildcardMatchAndEscape_AndOtherCriteria() throws Exception {
        if (!this.accessStackAdapter.supportsEscapeInLike()) {
            return;
        }
        this.createArtistsWildcardDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.andQualifier(ExpressionFactory.likeExp("artistName", (Object)"=_%", '='));
        query.andQualifier(Artist.ARTIST_NAME.eq("_X"));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testSelectLike_WildcardMatchIgnoreCaseAndEscape_AndOtherCriteria() throws Exception {
        if (!this.accessStackAdapter.supportsEscapeInLike()) {
            return;
        }
        this.createArtistsWildcardDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.andQualifier(ExpressionFactory.likeIgnoreCaseExp("artistName", (Object)"=_%", '='));
        query.andQualifier(Artist.ARTIST_NAME.eq("_X"));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testSelectLike_WildcardMatchAndEscapeMulti_AndOtherCriteria() throws Exception {
        if (!this.accessStackAdapter.supportsEscapeInLike()) {
            return;
        }
        this.tArtist.insert(new Object[]{1, "_X_", null});
        this.tArtist.insert(new Object[]{2, "_X", null});
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.andQualifier(ExpressionFactory.likeExp("artistName", (Object)"#_%#_", '#'));
        query.andQualifier(Artist.ARTIST_NAME.eq("_X_"));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testSelectLikeMultiple_WildcardMatch() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.likeExp("artistName", (Object)"artist1%");
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)11L, (long)objects.size());
    }

    @Test
    public void testSelectLikeIgnoreCaseObjects1() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.likeIgnoreCaseExp("artistName", (Object)"ARTIST%");
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)20L, (long)objects.size());
    }

    @Test
    public void testSelectLikeIgnoreCaseObjects2() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.likeIgnoreCaseExp("artistName", (Object)"artist%");
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)20L, (long)objects.size());
    }

    @Test
    public void testSelectIn() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.exp("artistName in ('artist1', 'artist2')", new Object[0]);
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
    }

    @Test
    public void testSelectParameterizedIn() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.exp("artistName in $list", new Object[0]);
        query.setQualifier(qual);
        query = query.queryWithParameters(Collections.singletonMap("list", new Object[]{"artist1", "artist2"}));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
    }

    @Test
    public void testSelectParameterizedEmptyIn() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.exp("artistName in $list", new Object[0]);
        query.setQualifier(qual);
        query = query.queryWithParameters(Collections.singletonMap("list", new Object[0]));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)0L, (long)objects.size());
    }

    @Test
    public void testSelectParameterizedEmptyNotIn() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.exp("artistName not in $list", new Object[0]);
        query.setQualifier(qual);
        query = query.queryWithParameters(Collections.singletonMap("list", new Object[0]));
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)20L, (long)objects.size());
    }

    @Test
    public void testSelectEmptyIn() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.inExp("artistName", new Object[0]);
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)0L, (long)objects.size());
    }

    @Test
    public void testSelectEmptyNotIn() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.notInExp("artistName", new Object[0]);
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)20L, (long)objects.size());
    }

    @Test
    public void testSelectBooleanTrue() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.expTrue();
        qual = qual.andExp(ExpressionFactory.matchExp("artistName", (Object)"artist1"));
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testSelectBooleanNotTrueOr() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.expTrue();
        qual = qual.notExp();
        qual = qual.orExp(ExpressionFactory.matchExp("artistName", (Object)"artist1"));
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testSelectBooleanFalse() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.expFalse();
        qual = qual.andExp(ExpressionFactory.matchExp("artistName", (Object)"artist1"));
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)0L, (long)objects.size());
    }

    @Test
    public void testSelectBooleanFalseOr() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.expFalse();
        qual = qual.orExp(ExpressionFactory.matchExp("artistName", (Object)"artist1"));
        query.setQualifier(qual);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
    }

    @Test
    public void testSelect() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        List<Artist> objects = query.select(this.context);
        Assert.assertEquals((long)20L, (long)objects.size());
    }

    @Test
    public void testSelectOne() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Expression qual = ExpressionFactory.matchExp("artistName", (Object)"artist1");
        query.setQualifier(qual);
        Artist artist = query.selectOne(this.context);
        Assert.assertEquals((Object)"artist1", (Object)artist.getArtistName());
    }

    @Test
    public void testSelectFirst() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering(new Ordering(Artist.ARTIST_NAME.getName()));
        Artist artist = query.selectFirst(this.context);
        Assert.assertNotNull((Object)artist);
        Assert.assertEquals((Object)"artist1", (Object)artist.getArtistName());
    }

    @Test
    public void testSelectFirstByContext() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering(new Ordering(Artist.ARTIST_NAME.getName()));
        Artist artist = this.context.selectFirst(query);
        Assert.assertNotNull((Object)artist);
        Assert.assertEquals((Object)"artist1", (Object)artist.getArtistName());
    }

    @Test
    public void testIterate() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        final int[] count = new int[1];
        q1.iterate(this.context, new ResultIteratorCallback<Artist>(){

            @Override
            public void next(Artist object) {
                Assert.assertNotNull((Object)object.getArtistName());
                count[0] = count[0] + 1;
            }
        });
        Assert.assertEquals((long)20L, (long)count[0]);
    }

    @Test
    public void testIterator() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        try (ResultIterator<Artist> it = q1.iterator(this.context);){
            int count = 0;
            for (Artist a : it) {
                ++count;
            }
            Assert.assertEquals((long)20L, (long)count);
        }
    }

    @Test
    public void testBatchIterator() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        try (ResultBatchIterator<Artist> it = q1.batchIterator(this.context, 5);){
            int count = 0;
            for (List<Artist> list : it) {
                ++count;
                Assert.assertEquals((long)5L, (long)list.size());
            }
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void testRouteWithPrefetches() {
        EntityResolver resolver = this.context.getEntityResolver();
        MockQueryRouter router = new MockQueryRouter();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("artistName", (Object)"a"));
        q.route(router, resolver, null);
        Assert.assertEquals((long)1L, (long)router.getQueryCount());
        q.addPrefetch("paintingArray");
        router.reset();
        q.route(router, resolver, null);
        Assert.assertEquals((long)2L, (long)router.getQueryCount());
        q.addPrefetch("paintingArray.toGallery");
        router.reset();
        q.route(router, resolver, null);
        Assert.assertEquals((long)3L, (long)router.getQueryCount());
        q.addPrefetch("artistExhibitArray.toExhibit");
        router.reset();
        q.route(router, resolver, null);
        Assert.assertEquals((long)4L, (long)router.getQueryCount());
        q.removePrefetch("paintingArray");
        router.reset();
        q.route(router, resolver, null);
        Assert.assertEquals((long)3L, (long)router.getQueryCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRouteQueryWithPrefetchesNoReverse() {
        EntityResolver resolver = this.context.getEntityResolver();
        ObjEntity paintingEntity = resolver.getObjEntity(Painting.class);
        ObjEntity galleryEntity = resolver.getObjEntity(Gallery.class);
        ObjEntity artistExhibitEntity = resolver.getObjEntity(ArtistExhibit.class);
        ObjEntity exhibitEntity = resolver.getObjEntity(Exhibit.class);
        ObjRelationship paintingToArtistRel = paintingEntity.getRelationship("toArtist");
        paintingEntity.removeRelationship("toArtist");
        ObjRelationship galleryToPaintingRel = galleryEntity.getRelationship("paintingArray");
        galleryEntity.removeRelationship("paintingArray");
        ObjRelationship artistExhibitToArtistRel = artistExhibitEntity.getRelationship("toArtist");
        artistExhibitEntity.removeRelationship("toArtist");
        ObjRelationship exhibitToArtistExhibitRel = exhibitEntity.getRelationship("artistExhibitArray");
        exhibitEntity.removeRelationship("artistExhibitArray");
        Expression e = ExpressionFactory.matchExp("artistName", (Object)"artist1");
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, e);
        q.addPrefetch("paintingArray");
        q.addPrefetch("paintingArray.toGallery");
        q.addPrefetch("artistExhibitArray.toExhibit");
        try {
            MockQueryRouter router = new MockQueryRouter();
            q.route(router, resolver, null);
            Assert.assertEquals((long)4L, (long)router.getQueryCount());
        }
        finally {
            paintingEntity.addRelationship(paintingToArtistRel);
            galleryEntity.addRelationship(galleryToPaintingRel);
            artistExhibitEntity.addRelationship(artistExhibitToArtistRel);
            exhibitEntity.addRelationship(exhibitToArtistExhibitRel);
        }
    }

    @Test
    public void testRouteQueryWithPrefetchesPrefetchExpressionPath() {
        Expression exp = ExpressionFactory.noMatchExp("toArtist", new Object());
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class, exp);
        q.addPrefetch("toArtist");
        EntityResolver resolver = this.context.getEntityResolver();
        MockQueryRouter router = new MockQueryRouter();
        q.route(router, resolver, null);
        Assert.assertEquals((long)2L, (long)router.getQueryCount());
    }

    @Test
    public void testLeftJoinAndPrefetchToMany() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("paintingArray+.toGallery", null));
        query.addPrefetch("artistExhibitArray");
        this.context.select(query);
    }

    @Test
    public void testLeftJoinAndPrefetchToOne() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class, ExpressionFactory.matchExp("toArtist+.artistName", null));
        query.addPrefetch("toGallery");
        this.context.select(query);
    }

    @Test
    public void testMatchObject() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("a2");
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("a3");
        this.context.commitChanges();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setQualifier(ExpressionFactory.matchExp(a2));
        Artist result = query.selectOne(this.context);
        Assert.assertSame((Object)a2, (Object)result);
    }

    @Test
    public void testMatchObjects() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("a2");
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("a3");
        this.context.commitChanges();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setQualifier(ExpressionFactory.matchAnyExp(a1, a3));
        query.addOrdering(Artist.ARTIST_NAME.asc());
        List<Artist> list = query.select(this.context);
        Assert.assertEquals((long)list.size(), (long)2L);
        Assert.assertSame((Object)a1, (Object)list.get(0));
        Assert.assertSame((Object)a3, (Object)list.get(1));
    }

    @Test
    public void testMatchByRelatedObject() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("a2");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        p1.setToArtist(a1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("p2");
        p2.setToArtist(a2);
        this.context.commitChanges();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.setQualifier(ExpressionFactory.matchExp("toArtist", (Object)a1));
        Assert.assertSame((Object)p1, (Object)query.selectOne(this.context));
    }

    @Test
    public void testMatchByRelatedObjectId() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("a2");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        p1.setToArtist(a1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("p2");
        p2.setToArtist(a2);
        this.context.commitChanges();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.setQualifier(ExpressionFactory.matchExp("toArtist", (Object)a1.getObjectId()));
        Assert.assertSame((Object)p1, (Object)query.selectOne(this.context));
    }

    @Test
    public void testMatchByRelatedObjectIdValue() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("a2");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        p1.setToArtist(a1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("p2");
        p2.setToArtist(a2);
        this.context.commitChanges();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.setQualifier(ExpressionFactory.matchExp("toArtist", (Object)Cayenne.longPKForObject(a1)));
        Assert.assertSame((Object)p1, (Object)query.selectOne(this.context));
    }

    @Test
    public void testSelect_WithOrdering() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("a2");
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("a3");
        this.context.commitChanges();
        List<Ordering> orderings = Arrays.asList(new Ordering("artistName", SortOrder.ASCENDING));
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, null, orderings);
        List<Artist> list = this.context.select(query);
        Assert.assertEquals((long)list.size(), (long)3L);
        Assert.assertSame((Object)list.get(0), (Object)a1);
        Assert.assertSame((Object)list.get(1), (Object)a2);
        Assert.assertSame((Object)list.get(2), (Object)a3);
    }

    @Test
    public void testSelectLongIn() throws Exception {
        this.createArtistsDataSet();
        Object[] names = new String[2009];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "artist" + i;
        }
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, ExpressionFactory.inExp("artistName", names));
        List<Artist> artists = query.select(this.context);
        Assert.assertEquals((long)20L, (long)artists.size());
    }

    @Test
    public void testSelectLongNotIn() throws Exception {
        if (!this.accessStackAdapter.supportsLongIn()) {
            return;
        }
        this.createArtistsDataSet();
        Object[] names = new String[1001];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "artist" + (i + 2);
        }
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, ExpressionFactory.notInExp("artistName", names));
        List<Artist> artists = query.select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
    }

    @Test
    public void testCacheOffsetAndLimit() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query1 = new SelectQuery<Artist>(Artist.class);
        query1.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        query1.setFetchOffset(0);
        query1.setFetchLimit(10);
        this.context.performQuery(query1);
        SelectQuery<Artist> query2 = new SelectQuery<Artist>(Artist.class);
        query2.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        query2.setFetchOffset(10);
        query2.setFetchLimit(10);
        this.context.performQuery(query2);
        SelectQuery<Artist> query3 = new SelectQuery<Artist>(Artist.class);
        query3.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        query3.setFetchOffset(10);
        query3.setFetchLimit(10);
        this.context.performQuery(query3);
        Assert.assertFalse((boolean)query1.metaData.getCacheKey().equals(query2.metaData.cacheKey));
        Assert.assertEquals((Object)query2.metaData.getCacheKey(), (Object)query3.metaData.getCacheKey());
    }
}

