/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EJBQLQueryDescriptor;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.test.file.FileUtil;
import org.apache.cayenne.testdo.embeddable.Embeddable1;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.util.XMLEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.InputSource;

public class MapLoaderLoadTest {
    private InputSource getMapXml(String mapName) {
        return new InputSource(this.getClass().getClassLoader().getResourceAsStream(mapName));
    }

    @Test
    public void testLoadEmbeddableMap() throws Exception {
        MapLoader mapLoader = new MapLoader();
        DataMap map = mapLoader.loadDataMap(this.getMapXml("embeddable.map.xml"));
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)1L, (long)map.getEmbeddables().size());
        Embeddable e = map.getEmbeddable(Embeddable1.class.getName());
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)Embeddable1.class.getName(), (Object)e.getClassName());
        Assert.assertEquals((long)2L, (long)e.getAttributes().size());
        EmbeddableAttribute ea1 = e.getAttribute("embedded10");
        Assert.assertNotNull((Object)ea1);
        Assert.assertEquals((Object)"embedded10", (Object)ea1.getName());
        Assert.assertEquals((Object)"java.lang.String", (Object)ea1.getType());
        Assert.assertEquals((Object)"EMBEDDED10", (Object)ea1.getDbAttributeName());
        EmbeddableAttribute ea2 = e.getAttribute("embedded20");
        Assert.assertNotNull((Object)ea2);
        Assert.assertEquals((Object)"embedded20", (Object)ea2.getName());
        Assert.assertEquals((Object)"java.lang.String", (Object)ea2.getType());
        Assert.assertEquals((Object)"EMBEDDED20", (Object)ea2.getDbAttributeName());
        ObjEntity oe = map.getObjEntity("EmbedEntity1");
        Assert.assertNotNull((Object)oe);
        Assert.assertEquals((long)3L, (long)oe.getDeclaredAttributes().size());
        EmbeddedAttribute oea1 = (EmbeddedAttribute)oe.getAttribute("embedded1");
        Assert.assertNotNull((Object)oea1);
        Assert.assertEquals((Object)Embeddable1.class.getName(), (Object)oea1.getType());
        Assert.assertEquals((long)0L, (long)oea1.getAttributeOverrides().size());
        EmbeddedAttribute oea2 = (EmbeddedAttribute)oe.getAttribute("embedded2");
        Assert.assertNotNull((Object)oea2);
        Assert.assertEquals((Object)Embeddable1.class.getName(), (Object)oea2.getType());
        Assert.assertEquals((long)2L, (long)oea2.getAttributeOverrides().size());
    }

    @Test
    public void testLoadTestMap() throws Exception {
        MapLoader mapLoader = new MapLoader();
        DataMap map = mapLoader.loadDataMap(this.getMapXml("testmap.map.xml"));
        Assert.assertNotNull((Object)map);
        Procedure procedure = map.getProcedure("cayenne_tst_upd_proc");
        Assert.assertNotNull((Object)procedure);
        List<ProcedureParameter> params = procedure.getCallParameters();
        Assert.assertNotNull(params);
        Assert.assertEquals((long)1L, (long)params.size());
        ProcedureParameter param = params.get(0);
        Assert.assertNotNull((Object)param);
        Assert.assertEquals((Object)"paintingPrice", (Object)param.getName());
        Assert.assertEquals((long)1L, (long)param.getDirection());
        ObjEntity ent = map.getObjEntity("Painting");
        Assert.assertNotNull((Object)ent.getSuperClassName());
        ObjEntity artistCallbackTestEntity = map.getObjEntity("ArtistCallback");
        Assert.assertTrue((boolean)artistCallbackTestEntity.isExcludingDefaultListeners());
        Assert.assertTrue((boolean)artistCallbackTestEntity.isExcludingSuperclassListeners());
        this.checkLoadedQueries(map);
    }

    @Test
    public void testEncodeAsXML() throws FileNotFoundException {
        MapLoader mapLoader = new MapLoader();
        DataMap map = mapLoader.loadDataMap(this.getMapXml("testmap.map.xml"));
        Assert.assertNotNull((Object)map);
        File file = new File(FileUtil.baseTestDirectory(), "testmap_generated.map.xml");
        PrintWriter pw = new PrintWriter(new FileOutputStream(file));
        map.encodeAsXML(new XMLEncoder(pw));
        pw.close();
    }

    private void checkLoadedQueries(DataMap map) throws Exception {
        SelectQueryDescriptor queryWithQualifier = (SelectQueryDescriptor)map.getQueryDescriptor("QueryWithQualifier");
        Assert.assertNotNull((Object)queryWithQualifier);
        Assert.assertTrue((boolean)(queryWithQualifier.getRoot() instanceof ObjEntity));
        Assert.assertEquals((Object)"Artist", (Object)((Entity)queryWithQualifier.getRoot()).getName());
        Assert.assertNotNull((Object)queryWithQualifier.getQualifier());
        SelectQueryDescriptor queryWithOrdering = (SelectQueryDescriptor)map.getQueryDescriptor("QueryWithOrdering");
        Assert.assertNotNull((Object)queryWithOrdering);
        Assert.assertTrue((boolean)(queryWithOrdering.getRoot() instanceof ObjEntity));
        Assert.assertEquals((Object)"Artist", (Object)((Entity)queryWithOrdering.getRoot()).getName());
        Assert.assertEquals((long)2L, (long)queryWithOrdering.getOrderings().size());
        Ordering artistNameOrdering = queryWithOrdering.getOrderings().get(0);
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getName(), (Object)artistNameOrdering.getSortSpecString());
        Assert.assertFalse((boolean)artistNameOrdering.isAscending());
        Assert.assertTrue((boolean)artistNameOrdering.isCaseInsensitive());
        Ordering dobOrdering = queryWithOrdering.getOrderings().get(1);
        Assert.assertEquals((Object)Artist.DATE_OF_BIRTH.getName(), (Object)dobOrdering.getSortSpecString());
        Assert.assertTrue((boolean)dobOrdering.isAscending());
        Assert.assertFalse((boolean)dobOrdering.isCaseInsensitive());
        SelectQueryDescriptor queryWithPrefetch = (SelectQueryDescriptor)map.getQueryDescriptor("QueryWithPrefetch");
        Assert.assertNotNull((Object)queryWithPrefetch);
        Assert.assertTrue((boolean)(queryWithPrefetch.getRoot() instanceof ObjEntity));
        Assert.assertEquals((Object)"Gallery", (Object)((Entity)queryWithPrefetch.getRoot()).getName());
        Assert.assertNotNull(queryWithPrefetch.getPrefetches());
        Assert.assertEquals((long)1L, (long)queryWithPrefetch.getPrefetches().size());
        Assert.assertTrue((boolean)queryWithPrefetch.getPrefetches().contains(Gallery.PAINTING_ARRAY.getName()));
        QueryDescriptor nonSelectingQuery = map.getQueryDescriptor("NonSelectingQuery");
        Assert.assertNotNull((Object)nonSelectingQuery);
        Assert.assertEquals((Object)"NonSelectingQuery", (Object)nonSelectingQuery.getName());
        Assert.assertEquals((Object)"UPPER", (Object)nonSelectingQuery.getProperties().get("cayenne.SQLTemplate.columnNameCapitalization"));
        EJBQLQueryDescriptor ejbqlQueryTest = (EJBQLQueryDescriptor)map.getQueryDescriptor("EjbqlQueryTest");
        Assert.assertNotNull((Object)ejbqlQueryTest);
        Assert.assertEquals((Object)"EjbqlQueryTest", (Object)ejbqlQueryTest.getName());
        Assert.assertNotNull((Object)ejbqlQueryTest.getEjbql());
        Assert.assertEquals((Object)"SHARED_CACHE", (Object)ejbqlQueryTest.getProperties().get("cayenne.GenericSelectQuery.cacheStrategy"));
    }
}

