/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.MockDataChannelFilter;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.ListResponse;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataDomainFiltersIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testDefaultFilters() {
        DataDomain domain = this.runtime.getDataDomain();
        Assert.assertEquals((long)1L, (long)domain.filters.size());
    }

    @Test
    public void testOnQuery_FilterOrdering() {
        DataDomain domain = this.runtime.getDataDomain();
        final ArrayList results = new ArrayList();
        MockDataChannelFilter f1 = new MockDataChannelFilter(){

            @Override
            public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
                results.add("f1start");
                QueryResponse response = filterChain.onQuery(originatingContext, query);
                results.add("f1end");
                return response;
            }
        };
        MockDataChannelFilter f2 = new MockDataChannelFilter(){

            @Override
            public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
                results.add("f2start");
                QueryResponse response = filterChain.onQuery(originatingContext, query);
                results.add("f2end");
                return response;
            }
        };
        domain.filters.add(f1);
        domain.filters.add(f2);
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        QueryResponse response = domain.onQuery(this.context, query);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)"f2start", results.get(0));
        Assert.assertEquals((Object)"f1start", results.get(1));
        Assert.assertEquals((Object)"f1end", results.get(2));
        Assert.assertEquals((Object)"f2end", results.get(3));
    }

    @Test
    public void testOnSync_FilterOrdering() {
        DataDomain domain = this.runtime.getDataDomain();
        final ArrayList results = new ArrayList();
        MockDataChannelFilter f1 = new MockDataChannelFilter(){

            @Override
            public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelFilterChain filterChain) {
                results.add("f1start");
                GraphDiff response = filterChain.onSync(originatingContext, changes, syncType);
                results.add("f1end");
                return response;
            }
        };
        MockDataChannelFilter f2 = new MockDataChannelFilter(){

            @Override
            public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelFilterChain filterChain) {
                results.add("f2start");
                GraphDiff response = filterChain.onSync(originatingContext, changes, syncType);
                results.add("f2end");
                return response;
            }
        };
        domain.filters.add(f1);
        domain.filters.add(f2);
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("AAA");
        this.context.commitChanges();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)"f2start", results.get(0));
        Assert.assertEquals((Object)"f1start", results.get(1));
        Assert.assertEquals((Object)"f1end", results.get(2));
        Assert.assertEquals((Object)"f2end", results.get(3));
    }

    @Test
    public void testOnQuery_Blocking() {
        DataDomain domain = this.runtime.getDataDomain();
        final ListResponse r1 = new ListResponse();
        final ListResponse r2 = new ListResponse();
        MockDataChannelFilter f1 = new MockDataChannelFilter(){

            @Override
            public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
                return r1;
            }
        };
        MockDataChannelFilter f2 = new MockDataChannelFilter(){

            @Override
            public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
                return r2;
            }
        };
        domain.filters.add(f1);
        domain.filters.add(f2);
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        QueryResponse response = domain.onQuery(this.context, query);
        Assert.assertSame((Object)r2, (Object)response);
    }
}

