/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.CompoundPainting;
import org.apache.cayenne.testdo.testmap.CompoundPaintingLongNames;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextFlattenedAttributesIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    private void createTestDataSet() throws Exception {
        int i;
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        TableHelper tPainting = new TableHelper(this.dbHelper, "PAINTING");
        tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE", "GALLERY_ID"}).setColumnTypes(new int[]{4, 12, -5, 3, 4});
        TableHelper tPaintingInfo = new TableHelper(this.dbHelper, "PAINTING_INFO");
        tPaintingInfo.setColumns(new String[]{"PAINTING_ID", "TEXT_REVIEW"});
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        long dateBase = System.currentTimeMillis();
        for (i = 1; i <= 4; ++i) {
            tArtist.insert(new Object[]{i + 1, "artist" + i, new Date(dateBase + (long)(86400000 * i))});
        }
        for (i = 1; i <= 2; ++i) {
            tGallery.insert(new Object[]{i + 2, "gallery" + i});
        }
        for (i = 1; i <= 8; ++i) {
            Integer galleryId = i == 3 ? null : Integer.valueOf((i - 1) % 2 + 3);
            tPainting.insert(new Object[]{i, "painting" + i, (i - 1) % 4 + 2, new BigDecimal(1000.0), galleryId});
            tPaintingInfo.insert(new Object[]{i, "painting review" + i});
        }
    }

    @Test
    public void testSelectCompound1() throws Exception {
        this.createTestDataSet();
        SelectQuery<CompoundPainting> query = new SelectQuery<CompoundPainting>(CompoundPainting.class);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)8L, (long)objects.size());
        Assert.assertTrue((String)("CompoundPainting expected, got " + objects.get(0).getClass()), (boolean)(objects.get(0) instanceof CompoundPainting));
        for (CompoundPainting painting : objects) {
            Number id = (Number)painting.getObjectId().getIdSnapshot().get("PAINTING_ID");
            Assert.assertEquals((String)("CompoundPainting.getPaintingTitle(): " + painting.getPaintingTitle()), (Object)("painting" + id), (Object)painting.getPaintingTitle());
            if (painting.getToPaintingInfo() == null) {
                Assert.assertNull((Object)painting.getTextReview());
            } else {
                Assert.assertEquals((String)("CompoundPainting.getTextReview(): " + painting.getTextReview()), (Object)("painting review" + id), (Object)painting.getTextReview());
            }
            Assert.assertEquals((String)("CompoundPainting.getArtistName(): " + painting.getArtistName()), (Object)painting.getToArtist().getArtistName(), (Object)painting.getArtistName());
            if (painting.getToGallery() == null) {
                Assert.assertNull((Object)painting.getGalleryName());
                continue;
            }
            Assert.assertEquals((String)("CompoundPainting.getGalleryName(): " + painting.getGalleryName()), (Object)painting.getToGallery().getGalleryName(), (Object)painting.getGalleryName());
        }
    }

    @Test
    public void testSelectCompound2() throws Exception {
        this.createTestDataSet();
        SelectQuery<CompoundPainting> query = new SelectQuery<CompoundPainting>(CompoundPainting.class, ExpressionFactory.matchExp("artistName", (Object)"artist2"));
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((String)("CompoundPainting expected, got " + objects.get(0).getClass()), (boolean)(objects.get(0) instanceof CompoundPainting));
        for (CompoundPainting painting : objects) {
            Assert.assertEquals((long)3L, (long)painting.getPersistenceState());
            Assert.assertEquals((String)("CompoundPainting.getArtistName(): " + painting.getArtistName()), (Object)"artist2", (Object)painting.getArtistName());
            Assert.assertEquals((String)("CompoundPainting.getArtistName(): " + painting.getGalleryName()), (Object)painting.getToGallery().getGalleryName(), (Object)painting.getGalleryName());
        }
    }

    @Test
    public void testSelectCompoundLongNames() throws Exception {
        this.createTestDataSet();
        SelectQuery<CompoundPaintingLongNames> query = new SelectQuery<CompoundPaintingLongNames>(CompoundPaintingLongNames.class);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
    }

    @Test
    public void testSelectEJQBQL() throws Exception {
        this.createTestDataSet();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM CompoundPainting a WHERE a.artistName = 'artist2'");
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertTrue((String)("CompoundPainting expected, got " + objects.get(0).getClass()), (boolean)(objects.get(0) instanceof CompoundPainting));
        for (CompoundPainting painting : objects) {
            Assert.assertEquals((long)3L, (long)painting.getPersistenceState());
        }
    }

    @Test
    public void testSelectEJQBQLCollectionTheta() throws Exception {
        this.createTestDataSet();
        EJBQLQuery query = new EJBQLQuery("SELECT DISTINCT a FROM CompoundPainting cp, Artist a WHERE a.artistName=cp.artistName ORDER BY a.artistName");
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)4L, (long)objects.size());
        Iterator i = objects.iterator();
        int index = 1;
        while (i.hasNext()) {
            Artist artist = (Artist)i.next();
            Assert.assertEquals((Object)("artist" + index), (Object)artist.getArtistName());
            ++index;
        }
    }

    @Test
    public void testSelectEJQBQLLike() throws Exception {
        this.createTestDataSet();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM CompoundPainting a WHERE a.artistName LIKE 'artist%' ORDER BY a.paintingTitle");
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)8L, (long)objects.size());
        Iterator i = objects.iterator();
        int index = 1;
        while (i.hasNext()) {
            CompoundPainting painting = (CompoundPainting)i.next();
            Assert.assertEquals((Object)("painting" + index), (Object)painting.getPaintingTitle());
            ++index;
        }
    }

    @Test
    public void testSelectEJQBQLBetween() throws Exception {
        this.createTestDataSet();
        EJBQLQuery query = new EJBQLQuery("SELECT a FROM CompoundPainting a WHERE a.artistName BETWEEN 'artist1' AND 'artist4' ORDER BY a.paintingTitle");
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)8L, (long)objects.size());
        Iterator i = objects.iterator();
        int index = 1;
        while (i.hasNext()) {
            CompoundPainting painting = (CompoundPainting)i.next();
            Assert.assertEquals((Object)("painting" + index), (Object)painting.getPaintingTitle());
            ++index;
        }
    }

    @Test
    public void testSelectEJQBQLSubquery() throws Exception {
        this.createTestDataSet();
        EJBQLQuery query = new EJBQLQuery("SELECT g FROM Gallery g WHERE (SELECT COUNT(cp) FROM CompoundPainting cp WHERE g.galleryName=cp.galleryName) = 4");
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)1L, (long)objects.size());
        Gallery gallery = (Gallery)objects.get(0);
        Assert.assertEquals((Object)"gallery2", (Object)gallery.getGalleryName());
    }

    @Test
    public void testSelectEJQBQLHaving() throws Exception {
        this.createTestDataSet();
        EJBQLQuery query = new EJBQLQuery("SELECT cp.galleryName, COUNT(a) from  Artist a, CompoundPainting cp WHERE cp.artistName = a.artistName GROUP BY cp.galleryName HAVING cp.galleryName LIKE 'gallery1'");
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)1L, (long)objects.size());
        Object[] galleryItem = (Object[])objects.get(0);
        Assert.assertEquals((Object)"gallery1", (Object)galleryItem[0]);
        Assert.assertEquals((Object)3L, (Object)galleryItem[1]);
    }

    @Test
    public void testInsert() {
        CompoundPainting o1 = this.context.newObject(CompoundPainting.class);
        o1.setArtistName("A1");
        o1.setEstimatedPrice(new BigDecimal(1.0));
        o1.setGalleryName("G1");
        o1.setPaintingTitle("P1");
        o1.setTextReview("T1");
        this.context.commitChanges();
        Number artistCount = (Number)Cayenne.objectForQuery(this.context, new EJBQLQuery("select count(a) from Artist a"));
        Assert.assertEquals((long)1L, (long)artistCount.intValue());
        Number paintingCount = (Number)Cayenne.objectForQuery(this.context, new EJBQLQuery("select count(a) from Painting a"));
        Assert.assertEquals((long)1L, (long)paintingCount.intValue());
        Number galleryCount = (Number)Cayenne.objectForQuery(this.context, new EJBQLQuery("select count(a) from Gallery a"));
        Assert.assertEquals((long)1L, (long)galleryCount.intValue());
    }

    @Test
    public void testDelete() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("AX");
        this.context.commitChanges();
        CompoundPainting o1 = this.context.newObject(CompoundPainting.class);
        o1.setArtistName("A1");
        o1.setEstimatedPrice(new BigDecimal(1.0));
        o1.setGalleryName("G1");
        o1.setPaintingTitle("P1");
        o1.setTextReview("T1");
        this.context.commitChanges();
        this.context.deleteObjects(o1);
        this.context.commitChanges();
        Number artistCount = (Number)Cayenne.objectForQuery(this.context, new EJBQLQuery("select count(a) from Artist a"));
        Assert.assertEquals((long)1L, (long)artistCount.intValue());
        Number paintingCount = (Number)Cayenne.objectForQuery(this.context, new EJBQLQuery("select count(a) from Painting a"));
        Assert.assertEquals((long)0L, (long)paintingCount.intValue());
        Number galleryCount = (Number)Cayenne.objectForQuery(this.context, new EJBQLQuery("select count(a) from Gallery a"));
        Assert.assertEquals((long)0L, (long)galleryCount.intValue());
    }

    @Test
    public void testUpdate() {
        CompoundPainting o1 = this.context.newObject(CompoundPainting.class);
        o1.setArtistName("A1");
        o1.setEstimatedPrice(new BigDecimal(1.0));
        o1.setGalleryName("G1");
        o1.setPaintingTitle("P1");
        o1.setTextReview("T1");
        this.context.commitChanges();
        o1.setArtistName("X1");
        o1.setEstimatedPrice(new BigDecimal(2.0));
        o1.setGalleryName("X1");
        o1.setPaintingTitle("X1");
        o1.setTextReview("X1");
        this.context.commitChanges();
    }
}

