/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.util.PersistentObjectCollection;
import org.apache.cayenne.util.RelationshipFault;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentObjectList
extends RelationshipFault
implements List,
ValueHolder,
PersistentObjectCollection {
    protected List objectList;
    protected LinkedList<Object> addedToUnresolved;
    protected LinkedList<Object> removedFromUnresolved;

    private PersistentObjectList() {
    }

    public PersistentObjectList(Persistent relationshipOwner, String relationshipName) {
        super(relationshipOwner, relationshipName);
    }

    @Override
    public boolean isFault() {
        if (this.objectList != null) {
            return false;
        }
        if (this.isTransientParent()) {
            this.objectList = new LinkedList();
            return false;
        }
        return true;
    }

    @Override
    public void invalidate() {
        this.setObjectList(null);
    }

    @Override
    public Object setValueDirectly(Object value) throws CayenneRuntimeException {
        if (value == null || value instanceof List) {
            List old = this.objectList;
            this.setObjectList((List)value);
            return old;
        }
        throw new CayenneRuntimeException("Value must be a list, got: " + value.getClass().getName(), new Object[0]);
    }

    @Override
    public Object getValue() throws CayenneRuntimeException {
        return this.resolvedObjectList();
    }

    @Override
    public Object getValueDirectly() throws CayenneRuntimeException {
        return this.objectList;
    }

    @Override
    public Object setValue(Object value) throws CayenneRuntimeException {
        this.resolvedObjectList();
        return this.setValueDirectly(value);
    }

    public void setObjectList(List objectList) {
        this.objectList = objectList;
    }

    public boolean add(Object o) {
        if (this.isFault() ? this.addLocal(o) : this.objectList.add(o)) {
            this.postprocessAdd(o);
            return true;
        }
        return false;
    }

    public void add(int index, Object o) {
        this.resolvedObjectList().add(index, o);
        this.postprocessAdd(o);
    }

    public boolean addAll(Collection c) {
        if (this.resolvedObjectList().addAll(c)) {
            this.postprocessAdd(c);
            return true;
        }
        return false;
    }

    public boolean addAll(int index, Collection c) {
        if (this.resolvedObjectList().addAll(index, c)) {
            this.postprocessAdd(c);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        List resolved = this.resolvedObjectList();
        this.postprocessRemove(resolved);
        resolved.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.resolvedObjectList().contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.resolvedObjectList().containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PersistentObjectList)) {
            return false;
        }
        return ((Object)this.resolvedObjectList()).equals(((PersistentObjectList)o).resolvedObjectList());
    }

    @Override
    public int hashCode() {
        return 37 + ((Object)this.resolvedObjectList()).hashCode();
    }

    public Object get(int index) {
        return this.resolvedObjectList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.resolvedObjectList().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.resolvedObjectList().isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.resolvedObjectList().iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.resolvedObjectList().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.resolvedObjectList().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.resolvedObjectList().listIterator(index);
    }

    public Object remove(int index) {
        Object removed = this.resolvedObjectList().remove(index);
        this.postprocessRemove(removed);
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        if (this.isFault() ? this.removeLocal(o) : this.objectList.remove(o)) {
            this.postprocessRemove(o);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (this.resolvedObjectList().removeAll(c)) {
            this.postprocessRemove(c);
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        return this.resolvedObjectList().retainAll(c);
    }

    public Object set(int index, Object o) {
        Object oldValue = this.resolvedObjectList().set(index, o);
        this.postprocessAdd(o);
        this.postprocessRemove(oldValue);
        return oldValue;
    }

    @Override
    public int size() {
        return this.resolvedObjectList().size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.resolvedObjectList().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.resolvedObjectList().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.resolvedObjectList().toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List resolvedObjectList() {
        if (this.isFault()) {
            PersistentObjectList persistentObjectList = this;
            synchronized (persistentObjectList) {
                if (this.isFault()) {
                    this.objectList = this.resolveFromDB();
                }
            }
        }
        return this.objectList;
    }

    protected void clearLocalChanges() {
        this.addedToUnresolved = null;
        this.removedFromUnresolved = null;
    }

    @Override
    protected void mergeLocalChanges(List fetchedList) {
        if (this.isUncommittedParent()) {
            if (this.removedFromUnresolved != null) {
                fetchedList.removeAll(this.removedFromUnresolved);
            }
            if (this.addedToUnresolved != null && !this.addedToUnresolved.isEmpty()) {
                for (Object e : this.addedToUnresolved) {
                    Persistent dataObject;
                    if (e instanceof Persistent && (dataObject = (Persistent)e).getPersistenceState() == 1 || fetchedList.contains(e)) continue;
                    fetchedList.add(e);
                }
            }
        }
        this.clearLocalChanges();
    }

    protected boolean addLocal(Object object) {
        if (this.removedFromUnresolved != null) {
            this.removedFromUnresolved.remove(object);
        }
        if (this.addedToUnresolved == null) {
            this.addedToUnresolved = new LinkedList();
        }
        this.addedToUnresolved.addLast(object);
        return true;
    }

    protected boolean removeLocal(Object object) {
        if (this.addedToUnresolved != null) {
            this.addedToUnresolved.remove(object);
        }
        if (this.removedFromUnresolved == null) {
            this.removedFromUnresolved = new LinkedList();
        }
        if (this.shouldAddToRemovedFromUnresolvedList(object)) {
            this.removedFromUnresolved.addLast(object);
        }
        return true;
    }

    protected boolean shouldAddToRemovedFromUnresolvedList(Object object) {
        return true;
    }

    protected void postprocessAdd(Collection<?> collection) {
        for (Object next : collection) {
            this.postprocessAdd(next);
        }
    }

    protected void postprocessRemove(Collection<?> collection) {
        for (Object next : collection) {
            this.postprocessRemove(next);
        }
    }

    protected void postprocessAdd(Object addedObject) {
        if (this.relationshipOwner.getObjectContext() != null) {
            this.relationshipOwner.getObjectContext().propertyChanged(this.relationshipOwner, this.relationshipName, null, addedObject);
            if (addedObject instanceof Persistent) {
                Util.setReverse(this.relationshipOwner, this.relationshipName, (Persistent)addedObject);
            }
        }
    }

    protected void postprocessRemove(Object removedObject) {
        if (this.relationshipOwner.getObjectContext() != null) {
            this.relationshipOwner.getObjectContext().propertyChanged(this.relationshipOwner, this.relationshipName, removedObject, null);
            if (removedObject instanceof Persistent) {
                Util.unsetReverse(this.relationshipOwner, this.relationshipName, (Persistent)removedObject);
            }
        }
    }

    public String toString() {
        return this.objectList != null ? this.objectList.toString() : "[<unresolved>]";
    }

    @Override
    public void addDirectly(Object target) {
        if (this.isFault()) {
            this.addLocal(target);
        } else {
            this.objectList.add(target);
        }
    }

    @Override
    public void removeDirectly(Object target) {
        if (this.isFault()) {
            this.removeLocal(target);
        } else {
            this.objectList.remove(target);
        }
    }
}

