/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.naming.BasicNamingStrategy;
import org.apache.cayenne.map.naming.NamingStrategy;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.EntityMergeListener;
import org.apache.cayenne.util.NamedObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMergeSupport {
    private static final Map<String, String> CLASS_TO_PRIMITVE = new HashMap<String, String>();
    protected DataMap map;
    protected boolean removeMeaningfulFKs;
    protected boolean removeMeaningfulPKs;
    protected boolean usePrimitives;
    protected NamingStrategy namingStrategy;
    protected List<EntityMergeListener> listeners;

    public EntityMergeSupport(DataMap map) {
        this(map, new BasicNamingStrategy(), true);
    }

    public EntityMergeSupport(DataMap map, NamingStrategy namingStrategy, boolean removeMeaningfulPKs) {
        this.map = map;
        this.removeMeaningfulFKs = true;
        this.listeners = new ArrayList<EntityMergeListener>();
        this.removeMeaningfulPKs = removeMeaningfulPKs;
        this.namingStrategy = namingStrategy;
        this.addEntityMergeListener(DeleteRuleUpdater.getEntityMergeListener());
    }

    public boolean synchronizeWithDbEntities(Collection<ObjEntity> objEntities) {
        boolean changed = false;
        for (ObjEntity nextEntity : objEntities) {
            if (!this.synchronizeWithDbEntity(nextEntity)) continue;
            changed = true;
        }
        return changed;
    }

    protected boolean removePK(DbEntity dbEntity) {
        return this.removeMeaningfulPKs;
    }

    protected boolean removeFK(DbEntity dbEntity) {
        return this.removeMeaningfulFKs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchronizeWithDbEntity(ObjEntity entity) {
        if (entity == null) {
            return false;
        }
        DbEntity dbEntity = entity.getDbEntity();
        if (dbEntity == null) {
            return false;
        }
        boolean changed = false;
        DataMap dataMap = this.map;
        synchronized (dataMap) {
            if (this.removeFK(dbEntity)) {
                for (DbAttribute da : this.getMeaningfulFKs(entity)) {
                    ObjAttribute oa = entity.getAttributeForDbAttribute(da);
                    while (oa != null) {
                        String attrName = oa.getName();
                        entity.removeAttribute(attrName);
                        changed = true;
                        oa = entity.getAttributeForDbAttribute(da);
                    }
                }
            }
            for (DbAttribute da : this.getAttributesToAdd(entity)) {
                String primitive;
                String attrName = this.namingStrategy.createObjAttributeName(da);
                attrName = NamedObjectFactory.createName(ObjAttribute.class, entity, attrName);
                String type = TypesMapping.getJavaBySqlType(da.getType());
                if (this.usePrimitives && (primitive = CLASS_TO_PRIMITVE.get(type)) != null) {
                    type = primitive;
                }
                ObjAttribute oa = new ObjAttribute(attrName, type, entity);
                oa.setDbAttributePath(da.getName());
                entity.addAttribute(oa);
                this.fireAttributeAdded(oa);
                changed = true;
            }
            for (DbRelationship dr : this.getRelationshipsToAdd(entity)) {
                DbEntity targetEntity = (DbEntity)dr.getTargetEntity();
                for (ObjEntity mappedTarget : this.map.getMappedEntities(targetEntity)) {
                    String relationshipName = this.namingStrategy.createObjRelationshipName(dr);
                    relationshipName = NamedObjectFactory.createName(ObjRelationship.class, entity, relationshipName);
                    ObjRelationship or = new ObjRelationship(relationshipName);
                    or.addDbRelationship(dr);
                    or.setSourceEntity(entity);
                    or.setTargetEntity(mappedTarget);
                    entity.addRelationship(or);
                    this.fireRelationshipAdded(or);
                    changed = true;
                }
            }
        }
        return changed;
    }

    public Collection<DbAttribute> getMeaningfulFKs(ObjEntity objEntity) {
        ArrayList<DbAttribute> fks = new ArrayList<DbAttribute>(2);
        for (ObjAttribute property : objEntity.getAttributes()) {
            DbAttribute column = property.getDbAttribute();
            if (column == null || !column.isForeignKey()) continue;
            fks.add(column);
        }
        return fks;
    }

    protected List<DbAttribute> getAttributesToAdd(ObjEntity objEntity) {
        DbEntity dbEntity = objEntity.getDbEntity();
        ArrayList<DbAttribute> missing = new ArrayList<DbAttribute>();
        Collection<DbRelationship> rels = dbEntity.getRelationships();
        Collection<DbRelationship> incomingRels = this.getIncomingRelationships(dbEntity);
        for (DbAttribute dba : dbEntity.getAttributes()) {
            DbRelationship rel;
            boolean removeMeaningfulPKs;
            if (dba.getName() == null || objEntity.getAttributeForDbAttribute(dba) != null || (removeMeaningfulPKs = this.removePK(dbEntity)) && dba.isPrimaryKey()) continue;
            boolean isFK = false;
            Iterator<DbRelationship> rit = rels.iterator();
            block1: while (!isFK && rit.hasNext()) {
                rel = rit.next();
                for (DbJoin join : rel.getJoins()) {
                    if (join.getSource() != dba) continue;
                    isFK = true;
                    continue block1;
                }
            }
            if (!removeMeaningfulPKs ? !dba.isPrimaryKey() && isFK : isFK) continue;
            rit = incomingRels.iterator();
            block3: while (!isFK && rit.hasNext()) {
                rel = rit.next();
                for (DbJoin join : rel.getJoins()) {
                    if (join.getTarget() != dba) continue;
                    isFK = true;
                    continue block3;
                }
            }
            if (!removeMeaningfulPKs ? !dba.isPrimaryKey() && isFK : isFK) continue;
            missing.add(dba);
        }
        return missing;
    }

    private Collection<DbRelationship> getIncomingRelationships(DbEntity entity) {
        ArrayList<DbRelationship> incoming = new ArrayList<DbRelationship>();
        for (DbEntity nextEntity : entity.getDataMap().getDbEntities()) {
            for (DbRelationship relationship : nextEntity.getRelationships()) {
                if (entity != relationship.getTargetEntity()) continue;
                incoming.add(relationship);
            }
        }
        return incoming;
    }

    protected List<DbRelationship> getRelationshipsToAdd(ObjEntity objEntity) {
        ArrayList<DbRelationship> missing = new ArrayList<DbRelationship>();
        for (DbRelationship dbrel : objEntity.getDbEntity().getRelationships()) {
            if (dbrel.getName() == null || objEntity.getRelationshipForDbRelationship(dbrel) != null) continue;
            missing.add(dbrel);
        }
        return missing;
    }

    public DataMap getMap() {
        return this.map;
    }

    public void setMap(DataMap map) {
        this.map = map;
    }

    public boolean isRemoveMeaningfulFKs() {
        return this.removeMeaningfulFKs;
    }

    public void setRemoveMeaningfulFKs(boolean removeMeaningfulFKs) {
        this.removeMeaningfulFKs = removeMeaningfulFKs;
    }

    public void addEntityMergeListener(EntityMergeListener listener) {
        this.listeners.add(listener);
    }

    public void removeEntityMergeListener(EntityMergeListener listener) {
        this.listeners.remove(listener);
    }

    public EntityMergeListener[] getEntityMergeListeners() {
        return this.listeners.toArray(new EntityMergeListener[0]);
    }

    protected void fireAttributeAdded(ObjAttribute attr) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objAttributeAdded(attr);
        }
    }

    protected void fireRelationshipAdded(ObjRelationship rel) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objRelationshipAdded(rel);
        }
    }

    public void setNamingStrategy(NamingStrategy strategy) {
        this.namingStrategy = strategy;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    static {
        CLASS_TO_PRIMITVE.put(Byte.class.getName(), "byte");
        CLASS_TO_PRIMITVE.put(Long.class.getName(), "long");
        CLASS_TO_PRIMITVE.put(Double.class.getName(), "double");
        CLASS_TO_PRIMITVE.put(Boolean.class.getName(), "boolean");
        CLASS_TO_PRIMITVE.put(Float.class.getName(), "float");
        CLASS_TO_PRIMITVE.put(Short.class.getName(), "short");
        CLASS_TO_PRIMITVE.put(Integer.class.getName(), "int");
    }
}

