/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionalOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTransactionManager
implements TransactionManager {
    private DataDomain dataDomain;

    public DefaultTransactionManager(@Inject DataDomain dataDomain) {
        this.dataDomain = dataDomain;
    }

    @Override
    public <T> T performInTransaction(TransactionalOperation<T> op) {
        T t;
        Transaction currentTx = Transaction.getThreadTransaction();
        if (currentTx != null) {
            return op.perform();
        }
        Transaction tx = this.dataDomain.createTransaction();
        Transaction.bindThreadTransaction(tx);
        try {
            T result = op.perform();
            tx.commit();
            t = result;
        }
        catch (Exception ex) {
            tx.setRollbackOnly();
            throw new CayenneRuntimeException(ex);
        }
        finally {
            Transaction.bindThreadTransaction(null);
            if (tx.getStatus() == 7) {
                try {
                    tx.rollback();
                }
                catch (Exception e) {}
            }
        }
        return t;
    }
}

