/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.remote.IncrementalQuery;
import org.apache.cayenne.remote.IncrementalSelectQuery;
import org.apache.cayenne.remote.RangeQuery;
import org.apache.cayenne.util.IDUtil;
import org.apache.cayenne.util.IncrementalListResponse;
import org.apache.cayenne.util.Util;

public class RemoteIncrementalFaultList
implements List {
    static final Object PLACEHOLDER = new Object();
    protected List elements;
    protected String cacheKey;
    protected int pageSize;
    protected int unfetchedObjects;
    protected Query paginatedQuery;
    protected transient ObjectContext context;
    protected int rowWidth;
    private ListHelper helper;

    public RemoteIncrementalFaultList(ObjectContext context, Query paginatedQuery) {
        Query query;
        QueryMetadata metadata = paginatedQuery.getMetaData(context.getEntityResolver());
        if (metadata.getPageSize() <= 0) {
            throw new IllegalArgumentException("Page size must be positive: " + metadata.getPageSize());
        }
        this.pageSize = metadata.getPageSize();
        this.helper = metadata.isFetchingDataRows() ? new DataRowListHelper() : new PersistentListHelper();
        this.context = context;
        this.cacheKey = metadata.getCacheKey();
        if (this.cacheKey == null) {
            this.cacheKey = this.generateCacheKey();
        }
        query = (query = paginatedQuery) instanceof SelectQuery ? new IncrementalSelectQuery(paginatedQuery, this.cacheKey) : new IncrementalQuery(paginatedQuery, this.cacheKey);
        this.paginatedQuery = query;
        QueryResponse response = context.getChannel().onQuery(context, query);
        List firstPage = response.firstList();
        if (firstPage.size() > this.pageSize) {
            throw new IllegalArgumentException("Returned page size (" + firstPage.size() + ") exceeds requested page size (" + this.pageSize + ")");
        }
        if (firstPage.size() < this.pageSize) {
            this.elements = new ArrayList(firstPage);
            this.unfetchedObjects = 0;
        } else if (response instanceof IncrementalListResponse) {
            int fullListSize = ((IncrementalListResponse)response).getFullSize();
            this.unfetchedObjects = fullListSize - firstPage.size();
            this.elements = new ArrayList(fullListSize);
            this.elements.addAll(firstPage);
            for (int i = this.pageSize; i < fullListSize; ++i) {
                this.elements.add(PLACEHOLDER);
            }
        } else {
            this.elements = new ArrayList(firstPage);
            this.unfetchedObjects = 0;
        }
    }

    private String generateCacheKey() {
        byte[] bytes = IDUtil.pseudoUniqueByteSequence8();
        StringBuffer buffer = new StringBuffer(17);
        buffer.append("I");
        for (byte aByte : bytes) {
            IDUtil.appendFormattedByte(buffer, aByte);
        }
        return buffer.toString();
    }

    public void resolveAll() {
        this.resolveInterval(0, this.size());
    }

    private boolean isUnresolved(Object object) {
        return object == PLACEHOLDER;
    }

    protected void resolveInterval(int fromIndex, int toIndex) {
        if (fromIndex >= toIndex || this.elements.isEmpty()) {
            return;
        }
        if (this.context == null) {
            throw new CayenneRuntimeException("No ObjectContext set, can't resolve objects.", new Object[0]);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > this.elements.size()) {
            toIndex = this.elements.size();
        }
        int fromPage = this.pageIndex(fromIndex);
        int toPage = this.pageIndex(toIndex - 1);
        int rangeStartIndex = -1;
        for (int i = fromPage; i <= toPage; ++i) {
            int pageStartIndex = i * this.pageSize;
            Object firstPageObject = this.elements.get(pageStartIndex);
            if (this.isUnresolved(firstPageObject)) {
                if (rangeStartIndex >= 0) continue;
                rangeStartIndex = pageStartIndex;
                continue;
            }
            if (rangeStartIndex < 0) continue;
            this.forceResolveInterval(rangeStartIndex, pageStartIndex);
            rangeStartIndex = -1;
        }
        if (rangeStartIndex >= 0) {
            this.forceResolveInterval(rangeStartIndex, toIndex);
        }
    }

    void forceResolveInterval(int fromIndex, int toIndex) {
        int fetchLimit;
        RangeQuery query;
        List sublist;
        int pastEnd = toIndex - this.size();
        if (pastEnd > 0) {
            toIndex = this.size();
        }
        if ((sublist = this.context.performQuery(query = new RangeQuery(this.cacheKey, fromIndex, fetchLimit = toIndex - fromIndex, this.paginatedQuery))).size() != fetchLimit) {
            throw new CayenneRuntimeException("Resolved range size '" + sublist.size() + "' is not the same as expected: " + fetchLimit, new Object[0]);
        }
        for (int i = 0; i < fetchLimit; ++i) {
            this.elements.set(fromIndex + i, sublist.get(i));
        }
        this.unfetchedObjects -= sublist.size();
    }

    int pageIndex(int elementIndex) {
        if (elementIndex < 0 || elementIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + elementIndex);
        }
        if (this.pageSize <= 0 || elementIndex < 0) {
            return -1;
        }
        return elementIndex / this.pageSize;
    }

    public ObjectContext getContext() {
        return this.context;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public ListIterator listIterator() {
        return new ListIteratorHelper(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListIteratorHelper(index);
    }

    public Iterator iterator() {
        return new Iterator(){
            int listIndex = 0;

            public boolean hasNext() {
                return this.listIndex < RemoteIncrementalFaultList.this.elements.size();
            }

            public Object next() {
                if (this.listIndex >= RemoteIncrementalFaultList.this.elements.size()) {
                    throw new NoSuchElementException("no more elements");
                }
                return RemoteIncrementalFaultList.this.get(this.listIndex++);
            }

            public void remove() {
                throw new UnsupportedOperationException("remove not supported.");
            }
        };
    }

    public void add(int index, Object element) {
        this.helper.validateListObject(element);
        this.elements.add(index, element);
    }

    public boolean add(Object o) {
        this.helper.validateListObject(o);
        return this.elements.add(o);
    }

    public boolean addAll(Collection c) {
        return this.elements.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        return this.elements.addAll(index, c);
    }

    public void clear() {
        this.elements.clear();
    }

    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        Object o = this.elements.get(index);
        if (this.isUnresolved(o)) {
            int pageStart = this.pageIndex(index) * this.pageSize;
            this.resolveInterval(pageStart, pageStart + this.pageSize);
            return this.elements.get(index);
        }
        return o;
    }

    public int indexOf(Object o) {
        return this.helper.indexOfObject(o);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int lastIndexOf(Object o) {
        return this.helper.lastIndexOfObject(o);
    }

    public Object remove(int index) {
        return this.elements.remove(index);
    }

    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    public boolean removeAll(Collection c) {
        return this.elements.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.elements.retainAll(c);
    }

    public Object set(int index, Object element) {
        this.helper.validateListObject(element);
        return this.elements.set(index, element);
    }

    public int size() {
        return this.elements.size();
    }

    public List subList(int fromIndex, int toIndex) {
        this.resolveInterval(fromIndex, toIndex);
        return this.elements.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        this.resolveAll();
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.resolveAll();
        return this.elements.toArray(a);
    }

    public int getUnfetchedObjects() {
        return this.unfetchedObjects;
    }

    class ListIteratorHelper
    implements ListIterator {
        int listIndex;

        public ListIteratorHelper(int startIndex) {
            this.listIndex = startIndex;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException("add operation not supported");
        }

        public boolean hasNext() {
            return this.listIndex < RemoteIncrementalFaultList.this.elements.size();
        }

        public boolean hasPrevious() {
            return this.listIndex > 0;
        }

        public Object next() {
            if (this.listIndex >= RemoteIncrementalFaultList.this.elements.size()) {
                throw new NoSuchElementException("at the end of the list");
            }
            return RemoteIncrementalFaultList.this.get(this.listIndex++);
        }

        public int nextIndex() {
            return this.listIndex;
        }

        public Object previous() {
            if (this.listIndex < 1) {
                throw new NoSuchElementException("at the beginning of the list");
            }
            return RemoteIncrementalFaultList.this.get(--this.listIndex);
        }

        public int previousIndex() {
            return this.listIndex - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove operation not supported");
        }

        public void set(Object o) {
            throw new UnsupportedOperationException("set operation not supported");
        }
    }

    class DataRowListHelper
    extends ListHelper {
        DataRowListHelper() {
        }

        boolean incorrectObjectType(Object object) {
            if (!(object instanceof Map)) {
                return true;
            }
            Map map = (Map)object;
            return map.size() != RemoteIncrementalFaultList.this.rowWidth;
        }
    }

    class PersistentListHelper
    extends ListHelper {
        PersistentListHelper() {
        }

        boolean incorrectObjectType(Object object) {
            if (!(object instanceof Persistent)) {
                return true;
            }
            Persistent persistent = (Persistent)object;
            return persistent.getObjectContext() != RemoteIncrementalFaultList.this.context;
        }
    }

    abstract class ListHelper {
        ListHelper() {
        }

        int indexOfObject(Object object) {
            if (this.incorrectObjectType(object)) {
                return -1;
            }
            for (int i = 0; i < RemoteIncrementalFaultList.this.elements.size(); ++i) {
                if (!Util.nullSafeEquals(object, RemoteIncrementalFaultList.this.get(i))) continue;
                return i;
            }
            return -1;
        }

        int lastIndexOfObject(Object object) {
            if (this.incorrectObjectType(object)) {
                return -1;
            }
            for (int i = RemoteIncrementalFaultList.this.elements.size() - 1; i >= 0; --i) {
                if (!Util.nullSafeEquals(object, RemoteIncrementalFaultList.this.get(i))) continue;
                return i;
            }
            return -1;
        }

        abstract boolean incorrectObjectType(Object var1);

        void validateListObject(Object object) throws IllegalArgumentException {
            if (this.incorrectObjectType(object)) {
                throw new IllegalArgumentException("Can't store this object: " + object);
            }
        }
    }
}

