/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.valueholder;

import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.BaseToOneProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.util.PersistentObjectHolder;

class ValueHolderProperty
extends BaseToOneProperty {
    ValueHolderProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName) {
        super(owner, targetDescriptor, accessor, reverseName);
    }

    public boolean isFault(Object object) {
        ValueHolder holder = (ValueHolder)this.accessor.getValue(object);
        return holder == null || holder.isFault();
    }

    public void invalidate(Object object) {
        ValueHolder holder = (ValueHolder)this.accessor.getValue(object);
        if (holder != null && !holder.isFault()) {
            holder.invalidate();
        }
    }

    public Object readPropertyDirectly(Object object) throws PropertyException {
        ValueHolder holder = (ValueHolder)this.accessor.getValue(object);
        return holder != null ? holder.getValueDirectly() : null;
    }

    public Object readProperty(Object object) throws PropertyException {
        return this.ensureValueHolderSet(object).getValue();
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyException {
        ValueHolder holder = (ValueHolder)this.accessor.getValue(object);
        if (holder == null) {
            holder = this.createValueHolder(object);
            this.accessor.setValue(object, holder);
        }
        holder.setValueDirectly(newValue);
    }

    public void writeProperty(Object object, Object oldValue, Object newValue) throws PropertyException {
        this.ensureValueHolderSet(object).setValueDirectly(newValue);
    }

    public void injectValueHolder(Object object) throws PropertyException {
        this.ensureValueHolderSet(object);
    }

    protected ValueHolder ensureValueHolderSet(Object object) throws PropertyException {
        ValueHolder holder = (ValueHolder)this.accessor.getValue(object);
        if (holder == null) {
            holder = this.createValueHolder(object);
            this.accessor.setValue(object, holder);
        }
        return holder;
    }

    protected ValueHolder createValueHolder(Object object) throws PropertyException {
        if (!(object instanceof Persistent)) {
            throw new PropertyException("ValueHolders for non-persistent objects are not supported.", (PropertyDescriptor)this, object, new Object[0]);
        }
        return new PersistentObjectHolder((Persistent)object, this.getName());
    }
}

