/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.BeanAccessor;
import org.apache.cayenne.reflect.ConverterFactory;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.UnresolvablePathException;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtils {
    public static Accessor createAccessor(Class<?> objectClass, String nestedPropertyName) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null class.");
        }
        if (Util.isEmptyString(nestedPropertyName)) {
            throw new IllegalArgumentException("Null or empty property name.");
        }
        StringTokenizer path = new StringTokenizer(nestedPropertyName, ".");
        if (path.countTokens() == 1) {
            return new BeanAccessor(objectClass, nestedPropertyName, null);
        }
        NestedBeanAccessor accessor = new NestedBeanAccessor(nestedPropertyName);
        while (path.hasMoreTokens()) {
            String token = path.nextToken();
            accessor.addAccessor(new BeanAccessor(objectClass, token, null));
        }
        return accessor;
    }

    public static Object getProperty(Object object, String nestedPropertyName) throws CayenneRuntimeException {
        if (object == null) {
            throw new IllegalArgumentException("Null object.");
        }
        if (Util.isEmptyString(nestedPropertyName)) {
            throw new IllegalArgumentException("Null or empty property name.");
        }
        StringTokenizer path = new StringTokenizer(nestedPropertyName, ".");
        int len = path.countTokens();
        Object value = object;
        String pathSegment = null;
        try {
            for (int i = 1; i <= len; ++i) {
                pathSegment = path.nextToken();
                if (value == null) {
                    throw new UnresolvablePathException("Null value in the middle of the path, failed on " + nestedPropertyName + " from " + object, new Object[0]);
                }
                value = PropertyUtils.getSimpleProperty(value, pathSegment);
            }
            return value;
        }
        catch (Exception e) {
            String objectType = value != null ? value.getClass().getName() : "<null>";
            throw new CayenneRuntimeException("Error reading property segment '" + pathSegment + "' in path '" + nestedPropertyName + "' for type " + objectType, (Throwable)e, new Object[0]);
        }
    }

    public static void setProperty(Object object, String nestedPropertyName, Object value) throws CayenneRuntimeException {
        String lastSegment;
        if (object == null) {
            throw new IllegalArgumentException("Null object.");
        }
        if (Util.isEmptyString(nestedPropertyName)) {
            throw new IllegalArgumentException("Null or invalid property name.");
        }
        int dot = nestedPropertyName.lastIndexOf(".");
        if (dot > 0) {
            lastSegment = nestedPropertyName.substring(dot + 1);
            String pathSegment = nestedPropertyName.substring(0, dot);
            if ((object = PropertyUtils.getProperty(object, pathSegment)) == null) {
                throw new IllegalArgumentException("Null object at the end of the segment '" + pathSegment + "'");
            }
        } else {
            lastSegment = nestedPropertyName;
        }
        try {
            PropertyUtils.setSimpleProperty(object, lastSegment, value);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error setting property segment '" + lastSegment + "' in path '" + nestedPropertyName + "'" + " to value '" + value + "' for object '" + object + "'", (Throwable)e, new Object[0]);
        }
    }

    static Object getSimpleProperty(Object object, String pathSegment) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(object.getClass(), pathSegment);
        if (descriptor != null) {
            Method reader = descriptor.getReadMethod();
            if (reader == null) {
                throw new IntrospectionException("Unreadable property '" + pathSegment + "'");
            }
            return reader.invoke(object, (Object[])null);
        }
        if (object instanceof Map) {
            return ((Map)object).get(pathSegment);
        }
        throw new IntrospectionException("No property '" + pathSegment + "' found in class " + object.getClass().getName());
    }

    static void setSimpleProperty(Object object, String pathSegment, Object value) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(object.getClass(), pathSegment);
        if (descriptor != null) {
            Method writer = descriptor.getWriteMethod();
            if (writer == null) {
                throw new IntrospectionException("Unwritable property '" + pathSegment + "'");
            }
            value = ConverterFactory.factory.getConverter(descriptor.getPropertyType()).convert(value, descriptor.getPropertyType());
            writer.invoke(object, value);
        } else if (object instanceof Map) {
            ((Map)object).put(pathSegment, value);
        } else {
            throw new IntrospectionException("No property '" + pathSegment + "' found in class " + object.getClass().getName());
        }
    }

    static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        BeanInfo info = Introspector.getBeanInfo(beanClass);
        for (PropertyDescriptor descriptor : descriptors = info.getPropertyDescriptors()) {
            if (!propertyName.equals(descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    static Class<?> normalizeType(Class<?> type) {
        if (type.isPrimitive()) {
            String className = type.getName();
            if ("byte".equals(className)) {
                return Byte.class;
            }
            if ("int".equals(className)) {
                return Integer.class;
            }
            if ("long".equals(className)) {
                return Long.class;
            }
            if ("short".equals(className)) {
                return Short.class;
            }
            if ("char".equals(className)) {
                return Character.class;
            }
            if ("double".equals(className)) {
                return Double.class;
            }
            if ("float".equals(className)) {
                return Float.class;
            }
            if ("boolean".equals(className)) {
                return Boolean.class;
            }
        }
        return type;
    }

    static Object defaultNullValueForType(Class<?> type) {
        if (type != null && type.isPrimitive()) {
            String className = type.getName();
            if ("byte".equals(className)) {
                return (byte)0;
            }
            if ("int".equals(className)) {
                return 0;
            }
            if ("long".equals(className)) {
                return 0L;
            }
            if ("short".equals(className)) {
                return (short)0;
            }
            if ("char".equals(className)) {
                return Character.valueOf('\u0000');
            }
            if ("double".equals(className)) {
                return new Double(0.0);
            }
            if ("float".equals(className)) {
                return new Float(0.0f);
            }
            if ("boolean".equals(className)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private PropertyUtils() {
    }

    static final class NestedBeanAccessor
    implements Accessor {
        private Collection<Accessor> accessors = new ArrayList<Accessor>();
        private String name;

        NestedBeanAccessor(String name) {
            this.name = name;
        }

        void addAccessor(Accessor accessor) {
            this.accessors.add(accessor);
        }

        public String getName() {
            return this.name;
        }

        public Object getValue(Object object) throws PropertyException {
            Object value = object;
            for (Accessor accessor : this.accessors) {
                if (value == null) {
                    throw new IllegalArgumentException("Null object at the end of the segment '" + accessor.getName() + "'");
                }
                value = accessor.getValue(value);
            }
            return value;
        }

        public void setValue(Object object, Object newValue) throws PropertyException {
            Object value = object;
            Iterator<Accessor> accessors = this.accessors.iterator();
            while (accessors.hasNext()) {
                Accessor accessor = accessors.next();
                if (accessors.hasNext()) {
                    value = accessor.getValue(value);
                    continue;
                }
                accessor.setValue(value, newValue);
            }
        }
    }
}

