/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DbRelationshipDetected;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropRelationshipToDb
extends AbstractToDbToken.Entity {
    private DbRelationship rel;

    public DropRelationshipToDb(DbEntity entity, DbRelationship rel) {
        super(entity);
        this.rel = rel;
    }

    public String getFkName() {
        if (this.rel instanceof DbRelationshipDetected) {
            return ((DbRelationshipDetected)this.rel).getFkName();
        }
        return null;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        String fkName = this.getFkName();
        if (fkName == null) {
            return Collections.emptyList();
        }
        QuotingStrategy context = adapter.getQuotingStrategy();
        StringBuilder buf = new StringBuilder();
        buf.append("ALTER TABLE ");
        buf.append(context.quotedFullyQualifiedName(this.getEntity()));
        buf.append(" DROP CONSTRAINT ");
        buf.append(fkName);
        return Collections.singletonList(buf.toString());
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createAddRelationshipToModel(this.getEntity(), this.rel);
    }

    @Override
    public String getTokenName() {
        return "Drop Relationship";
    }

    @Override
    public String getTokenValue() {
        StringBuilder s = new StringBuilder();
        s.append(this.rel.getSourceEntity().getName());
        s.append("->");
        s.append(this.rel.getTargetEntityName());
        return s.toString();
    }

    public DbRelationship getRelationship() {
        return this.rel;
    }
}

