/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property<E> {
    private final String name;

    public Property(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Property<Object> dot(String property) {
        return new Property<Object>(this.getName() + "." + property);
    }

    public <T> Property<T> dot(Property<T> property) {
        return new Property<E>(this.getName() + "." + property.getName());
    }

    public Expression isNull() {
        return ExpressionFactory.matchExp(this.getName(), null);
    }

    public Expression isNotNull() {
        return ExpressionFactory.matchExp(this.getName(), null).notExp();
    }

    public Expression isTrue() {
        return ExpressionFactory.matchExp(this.getName(), Boolean.TRUE);
    }

    public Expression isFalse() {
        return ExpressionFactory.matchExp(this.getName(), Boolean.FALSE);
    }

    public Expression eq(E value) {
        return ExpressionFactory.matchExp(this.getName(), value);
    }

    public Expression ne(E value) {
        return ExpressionFactory.noMatchExp(this.getName(), value);
    }

    public Expression like(E value) {
        return ExpressionFactory.likeExp(this.getName(), value);
    }

    public Expression likeInsensitive(E value) {
        return ExpressionFactory.likeIgnoreCaseExp(this.getName(), value);
    }

    public Expression nlike(E value) {
        return ExpressionFactory.notLikeExp(this.getName(), value);
    }

    public Expression nlikeInsensitive(E value) {
        return ExpressionFactory.notLikeIgnoreCaseExp(this.getName(), value);
    }

    public Expression between(E lower, E upper) {
        return ExpressionFactory.betweenExp(this.getName(), lower, upper);
    }

    public Expression in(E firstValue, E ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getName(), values);
    }

    public Expression nin(E firstValue, E ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getName(), values);
    }

    public Expression in(Collection<E> values) {
        return ExpressionFactory.inExp(this.getName(), values);
    }

    public Expression nin(Collection<E> values) {
        return ExpressionFactory.notInExp(this.getName(), values);
    }

    public Expression gt(E value) {
        return ExpressionFactory.greaterExp(this.getName(), value);
    }

    public Expression gte(E value) {
        return ExpressionFactory.greaterOrEqualExp(this.getName(), value);
    }

    public Expression lt(E value) {
        return ExpressionFactory.lessExp(this.getName(), value);
    }

    public Expression lte(E value) {
        return ExpressionFactory.lessOrEqualExp(this.getName(), value);
    }

    public Ordering asc() {
        return new Ordering(this.getName(), SortOrder.ASCENDING);
    }

    public List<Ordering> ascs() {
        ArrayList<Ordering> result = new ArrayList<Ordering>(1);
        result.add(this.asc());
        return result;
    }

    public Ordering ascInsensitive() {
        return new Ordering(this.getName(), SortOrder.ASCENDING_INSENSITIVE);
    }

    public List<Ordering> ascInsensitives() {
        ArrayList<Ordering> result = new ArrayList<Ordering>(1);
        result.add(this.ascInsensitive());
        return result;
    }

    public Ordering desc() {
        return new Ordering(this.getName(), SortOrder.DESCENDING);
    }

    public List<Ordering> descs() {
        ArrayList<Ordering> result = new ArrayList<Ordering>(1);
        result.add(this.desc());
        return result;
    }

    public Ordering descInsensitive() {
        return new Ordering(this.getName(), SortOrder.DESCENDING_INSENSITIVE);
    }

    public List<Ordering> descInsensitives() {
        ArrayList<Ordering> result = new ArrayList<Ordering>(1);
        result.add(this.descInsensitive());
        return result;
    }

    public PrefetchTreeNode joint() {
        PrefetchTreeNode node = this.prefetch();
        node.setSemantics(1);
        return node;
    }

    public PrefetchTreeNode disjoint() {
        PrefetchTreeNode node = this.prefetch();
        node.setSemantics(2);
        return node;
    }

    public PrefetchTreeNode disjointById() {
        PrefetchTreeNode node = this.prefetch();
        node.setSemantics(3);
        return node;
    }

    PrefetchTreeNode prefetch() {
        PrefetchTreeNode root = new PrefetchTreeNode();
        PrefetchTreeNode node = root.addPath(this.name);
        node.setPhantom(false);
        return node;
    }
}

