/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.dba.oracle.OracleBatchAction;
import org.apache.cayenne.dba.oracle.OracleLOBBatchAction;
import org.apache.cayenne.dba.oracle.OracleProcedureAction;
import org.apache.cayenne.dba.oracle.OracleSQLTemplateAction;
import org.apache.cayenne.dba.oracle.OracleSelectAction;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OracleActionBuilder
extends JdbcActionBuilder {
    OracleActionBuilder(JdbcAdapter adapter, EntityResolver resolver) {
        super(adapter, resolver);
    }

    @Override
    public SQLAction sqlAction(SQLTemplate query) {
        return new OracleSQLTemplateAction(query, this.adapter, this.getEntityResolver());
    }

    @Override
    public SQLAction batchAction(BatchQuery query) {
        if (OracleAdapter.isSupportsOracleLOB() && OracleAdapter.updatesLOBColumns(query)) {
            return new OracleLOBBatchAction(query, this.getAdapter());
        }
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        OracleBatchAction action = new OracleBatchAction(query, this.adapter, this.getEntityResolver());
        action.setBatch(runningAsBatch);
        return action;
    }

    @Override
    public SQLAction procedureAction(ProcedureQuery query) {
        return new OracleProcedureAction(query, this.getAdapter(), this.getEntityResolver());
    }

    @Override
    public <T> SQLAction objectSelectAction(SelectQuery<T> query) {
        return new OracleSelectAction(query, this.getAdapter(), this.getEntityResolver());
    }
}

