/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesMapping {
    public static final int NOT_DEFINED = Integer.MAX_VALUE;
    public static final String SQL_ARRAY = "ARRAY";
    public static final String SQL_BIGINT = "BIGINT";
    public static final String SQL_BINARY = "BINARY";
    public static final String SQL_BIT = "BIT";
    public static final String SQL_BLOB = "BLOB";
    public static final String SQL_BOOLEAN = "BOOLEAN";
    public static final String SQL_CLOB = "CLOB";
    public static final String SQL_CHAR = "CHAR";
    public static final String SQL_DATE = "DATE";
    public static final String SQL_DECIMAL = "DECIMAL";
    public static final String SQL_DOUBLE = "DOUBLE";
    public static final String SQL_FLOAT = "FLOAT";
    public static final String SQL_INTEGER = "INTEGER";
    public static final String SQL_LONGVARCHAR = "LONGVARCHAR";
    public static final String SQL_LONGVARBINARY = "LONGVARBINARY";
    public static final String SQL_NUMERIC = "NUMERIC";
    public static final String SQL_REAL = "REAL";
    public static final String SQL_SMALLINT = "SMALLINT";
    public static final String SQL_TINYINT = "TINYINT";
    public static final String SQL_TIME = "TIME";
    public static final String SQL_TIMESTAMP = "TIMESTAMP";
    public static final String SQL_VARBINARY = "VARBINARY";
    public static final String SQL_VARCHAR = "VARCHAR";
    public static final String SQL_OTHER = "OTHER";
    public static final String SQL_NULL = "NULL";
    public static final String JAVA_LONG = "java.lang.Long";
    public static final String JAVA_BYTES = "byte[]";
    public static final String JAVA_BOOLEAN = "java.lang.Boolean";
    public static final String JAVA_STRING = "java.lang.String";
    public static final String JAVA_SQLDATE = "java.sql.Date";
    public static final String JAVA_UTILDATE = "java.util.Date";
    public static final String JAVA_BIGDECIMAL = "java.math.BigDecimal";
    public static final String JAVA_DOUBLE = "java.lang.Double";
    public static final String JAVA_FLOAT = "java.lang.Float";
    public static final String JAVA_INTEGER = "java.lang.Integer";
    public static final String JAVA_SHORT = "java.lang.Short";
    public static final String JAVA_BYTE = "java.lang.Byte";
    public static final String JAVA_TIME = "java.sql.Time";
    public static final String JAVA_TIMESTAMP = "java.sql.Timestamp";
    public static final String JAVA_BLOB = "java.sql.Blob";
    private static final Map<String, Integer> sqlStringType = new HashMap<String, Integer>();
    private static final Map<Integer, String> sqlEnumType = new HashMap<Integer, String>();
    private static final Map<Integer, String> sqlEnumJava = new HashMap<Integer, String>();
    private static final Map<String, Integer> javaSqlEnum = new HashMap<String, Integer>();
    protected Map<Integer, List<TypeInfo>> databaseTypes = new HashMap<Integer, List<TypeInfo>>();

    public static boolean supportsLength(int type) {
        return type == -2 || type == 1 || type == 3 || type == 8 || type == 6 || type == 2 || type == 7 || type == -3 || type == 12;
    }

    public static boolean isNumeric(int type) {
        return type == -5 || type == -7 || type == 3 || type == 8 || type == 6 || type == 4 || type == 2 || type == 7 || type == 5 || type == -6;
    }

    public static boolean isDecimal(int type) {
        return type == 3 || type == 8 || type == 6 || type == 7 || type == 2;
    }

    public static String[] getDatabaseTypes() {
        Set<String> types = sqlStringType.keySet();
        return types.toArray(new String[types.size()]);
    }

    protected static String pickDataType(int jdbcType, TypeInfo[] alts) {
        String uppercase;
        int i;
        int len = alts.length;
        if (len == 0) {
            return null;
        }
        if (len == 1) {
            return alts[0].name;
        }
        String jdbcName = TypesMapping.getSqlNameByType(jdbcType).toUpperCase();
        for (int i2 = 0; i2 < len; ++i2) {
            if (!jdbcName.equalsIgnoreCase(alts[i2].name)) continue;
            return alts[i2].name;
        }
        long maxPrec = 0L;
        for (int i3 = 0; i3 < len; ++i3) {
            if (maxPrec >= alts[i3].precision) continue;
            maxPrec = alts[i3].precision;
        }
        ArrayList<TypeInfo> list = new ArrayList<TypeInfo>();
        for (int i4 = 0; i4 < len; ++i4) {
            if (maxPrec != alts[i4].precision) continue;
            list.add(alts[i4]);
        }
        int slen = list.size();
        if (slen == 1) {
            return ((TypeInfo)list.get((int)0)).name;
        }
        for (i = 0; i < slen; ++i) {
            uppercase = ((TypeInfo)list.get((int)i)).name.toUpperCase();
            if (!uppercase.startsWith(jdbcName) && !uppercase.endsWith(jdbcName)) continue;
            return ((TypeInfo)list.get((int)i)).name;
        }
        for (i = 0; i < slen; ++i) {
            uppercase = ((TypeInfo)list.get((int)i)).name.toUpperCase();
            if (!uppercase.contains(jdbcName)) continue;
            return ((TypeInfo)list.get((int)i)).name;
        }
        return ((TypeInfo)list.get((int)0)).name;
    }

    public static int getSqlTypeByName(String typeName) {
        Integer tmp = sqlStringType.get(typeName);
        return null == tmp ? Integer.MAX_VALUE : tmp;
    }

    public static String getSqlNameByType(int type) {
        return sqlEnumType.get(type);
    }

    public static int getSqlTypeByJava(String className) {
        Class<?> aClass;
        if (className == null) {
            return Integer.MAX_VALUE;
        }
        Integer type = javaSqlEnum.get(className);
        if (type != null) {
            return type;
        }
        try {
            aClass = Util.getJavaClass(className);
        }
        catch (Throwable th) {
            return Integer.MAX_VALUE;
        }
        return TypesMapping.getSqlTypeByJava(aClass);
    }

    public static int getSqlTypeByJava(Class<?> javaClass) {
        if (javaClass == null) {
            return Integer.MAX_VALUE;
        }
        for (Class<?> aClass = javaClass; aClass != null; aClass = aClass.getSuperclass()) {
            String name = aClass.isArray() ? aClass.getComponentType().getName() + "[]" : aClass.getName();
            Integer type = javaSqlEnum.get(name);
            if (type == null) continue;
            return ((Number)type).intValue();
        }
        if (javaClass.isArray()) {
            Class<?> elementType = javaClass.getComponentType();
            if (Character.class.isAssignableFrom(elementType) || Character.TYPE.isAssignableFrom(elementType)) {
                return 12;
            }
            if (Byte.class.isAssignableFrom(elementType) || Byte.TYPE.isAssignableFrom(elementType)) {
                return -3;
            }
        }
        if (Calendar.class.isAssignableFrom(javaClass)) {
            return 93;
        }
        if (BigInteger.class.isAssignableFrom(javaClass)) {
            return -5;
        }
        if (Serializable.class.isAssignableFrom(javaClass)) {
            return -3;
        }
        return Integer.MAX_VALUE;
    }

    public static String getJavaBySqlType(int type) {
        return sqlEnumJava.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypesMapping(DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = metaData.getTypeInfo();
        try {
            while (rs.next()) {
                TypeInfo info = new TypeInfo();
                info.name = rs.getString("TYPE_NAME");
                info.jdbcType = rs.getInt("DATA_TYPE");
                info.precision = rs.getLong("PRECISION");
                Integer key = info.jdbcType;
                List<TypeInfo> infos = this.databaseTypes.get(key);
                if (infos == null) {
                    infos = new ArrayList<TypeInfo>();
                    this.databaseTypes.put(key, infos);
                }
                infos.add(info);
            }
        }
        finally {
            rs.close();
        }
        Integer ts = 93;
        Integer dt = 91;
        List<TypeInfo> tsInfo = this.databaseTypes.get(ts);
        List<TypeInfo> dtInfo = this.databaseTypes.get(dt);
        if (tsInfo != null && dtInfo == null) {
            this.databaseTypes.put(dt, tsInfo);
        }
        if (dtInfo != null && tsInfo == null) {
            this.databaseTypes.put(ts, dtInfo);
        }
        Integer clob = 2005;
        Integer lvc = -1;
        List<TypeInfo> clobInfo = this.databaseTypes.get(clob);
        List<TypeInfo> lvcInfo = this.databaseTypes.get(lvc);
        if (clobInfo != null && lvcInfo == null) {
            this.databaseTypes.put(lvc, clobInfo);
        }
        if (lvcInfo != null && clobInfo == null) {
            this.databaseTypes.put(clob, lvcInfo);
        }
        Integer blob = 2004;
        Integer lvb = -4;
        List<TypeInfo> blobInfo = this.databaseTypes.get(blob);
        List<TypeInfo> lvbInfo = this.databaseTypes.get(lvb);
        if (blobInfo != null && lvbInfo == null) {
            this.databaseTypes.put(lvb, blobInfo);
        }
        if (lvbInfo != null && blobInfo == null) {
            this.databaseTypes.put(blob, lvbInfo);
        }
    }

    static {
        sqlStringType.put(SQL_ARRAY, 2003);
        sqlStringType.put(SQL_BIGINT, -5);
        sqlStringType.put(SQL_BINARY, -2);
        sqlStringType.put(SQL_BIT, -7);
        sqlStringType.put(SQL_BLOB, 2004);
        sqlStringType.put(SQL_BOOLEAN, 16);
        sqlStringType.put(SQL_CLOB, 2005);
        sqlStringType.put(SQL_CHAR, 1);
        sqlStringType.put(SQL_DATE, 91);
        sqlStringType.put(SQL_DECIMAL, 3);
        sqlStringType.put(SQL_DOUBLE, 8);
        sqlStringType.put(SQL_FLOAT, 6);
        sqlStringType.put(SQL_INTEGER, 4);
        sqlStringType.put(SQL_LONGVARCHAR, -1);
        sqlStringType.put(SQL_LONGVARBINARY, -4);
        sqlStringType.put(SQL_NUMERIC, 2);
        sqlStringType.put(SQL_REAL, 7);
        sqlStringType.put(SQL_SMALLINT, 5);
        sqlStringType.put(SQL_TINYINT, -6);
        sqlStringType.put(SQL_TIME, 92);
        sqlStringType.put(SQL_TIMESTAMP, 93);
        sqlStringType.put(SQL_VARBINARY, -3);
        sqlStringType.put(SQL_VARCHAR, 12);
        sqlStringType.put(SQL_OTHER, 1111);
        sqlStringType.put(SQL_NULL, 0);
        sqlEnumType.put(2003, SQL_ARRAY);
        sqlEnumType.put(-5, SQL_BIGINT);
        sqlEnumType.put(-2, SQL_BINARY);
        sqlEnumType.put(-7, SQL_BIT);
        sqlEnumType.put(16, SQL_BOOLEAN);
        sqlEnumType.put(2004, SQL_BLOB);
        sqlEnumType.put(2005, SQL_CLOB);
        sqlEnumType.put(1, SQL_CHAR);
        sqlEnumType.put(91, SQL_DATE);
        sqlEnumType.put(3, SQL_DECIMAL);
        sqlEnumType.put(8, SQL_DOUBLE);
        sqlEnumType.put(6, SQL_FLOAT);
        sqlEnumType.put(4, SQL_INTEGER);
        sqlEnumType.put(-1, SQL_LONGVARCHAR);
        sqlEnumType.put(-4, SQL_LONGVARBINARY);
        sqlEnumType.put(2, SQL_NUMERIC);
        sqlEnumType.put(7, SQL_REAL);
        sqlEnumType.put(5, SQL_SMALLINT);
        sqlEnumType.put(-6, SQL_TINYINT);
        sqlEnumType.put(92, SQL_TIME);
        sqlEnumType.put(93, SQL_TIMESTAMP);
        sqlEnumType.put(-3, SQL_VARBINARY);
        sqlEnumType.put(12, SQL_VARCHAR);
        sqlEnumType.put(1111, SQL_OTHER);
        sqlEnumType.put(0, SQL_NULL);
        sqlEnumJava.put(-5, JAVA_LONG);
        sqlEnumJava.put(-2, JAVA_BYTES);
        sqlEnumJava.put(-7, JAVA_BOOLEAN);
        sqlEnumJava.put(16, JAVA_BOOLEAN);
        sqlEnumJava.put(2004, JAVA_BYTES);
        sqlEnumJava.put(2005, JAVA_STRING);
        sqlEnumJava.put(1, JAVA_STRING);
        sqlEnumJava.put(91, JAVA_UTILDATE);
        sqlEnumJava.put(3, JAVA_BIGDECIMAL);
        sqlEnumJava.put(8, JAVA_DOUBLE);
        sqlEnumJava.put(6, JAVA_FLOAT);
        sqlEnumJava.put(4, JAVA_INTEGER);
        sqlEnumJava.put(-1, JAVA_STRING);
        sqlEnumJava.put(-4, JAVA_BYTES);
        sqlEnumJava.put(2, JAVA_BIGDECIMAL);
        sqlEnumJava.put(7, JAVA_FLOAT);
        sqlEnumJava.put(5, JAVA_SHORT);
        sqlEnumJava.put(-6, JAVA_SHORT);
        sqlEnumJava.put(92, JAVA_UTILDATE);
        sqlEnumJava.put(93, JAVA_UTILDATE);
        sqlEnumJava.put(-3, JAVA_BYTES);
        sqlEnumJava.put(12, JAVA_STRING);
        javaSqlEnum.put(JAVA_LONG, -5);
        javaSqlEnum.put(JAVA_BYTES, -2);
        javaSqlEnum.put(JAVA_BOOLEAN, -7);
        javaSqlEnum.put(JAVA_STRING, 12);
        javaSqlEnum.put(JAVA_SQLDATE, 91);
        javaSqlEnum.put(JAVA_UTILDATE, 91);
        javaSqlEnum.put(JAVA_TIMESTAMP, 93);
        javaSqlEnum.put(JAVA_BIGDECIMAL, 3);
        javaSqlEnum.put(JAVA_DOUBLE, 8);
        javaSqlEnum.put(JAVA_FLOAT, 6);
        javaSqlEnum.put(JAVA_INTEGER, 4);
        javaSqlEnum.put(JAVA_SHORT, 5);
        javaSqlEnum.put(JAVA_BYTE, 5);
        javaSqlEnum.put(JAVA_TIME, 92);
        javaSqlEnum.put(JAVA_TIMESTAMP, 93);
        javaSqlEnum.put("byte", -6);
        javaSqlEnum.put("int", 4);
        javaSqlEnum.put("short", 5);
        javaSqlEnum.put("char", 1);
        javaSqlEnum.put("double", 8);
        javaSqlEnum.put("long", -5);
        javaSqlEnum.put("float", 6);
        javaSqlEnum.put("boolean", -7);
    }

    static class TypeInfo {
        String name;
        int jdbcType;
        long precision;

        TypeInfo() {
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[   TypeInfo: ").append(this.name);
            buf.append("\n    JDBC Type: ").append(TypesMapping.getSqlNameByType(this.jdbcType));
            buf.append("\n    Precision: ").append(this.precision);
            buf.append("\n]");
            return buf.toString();
        }
    }
}

