/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.BatchQueryBuilderFactory;
import org.apache.cayenne.access.jdbc.EJBQLTranslatorFactory;
import org.apache.cayenne.access.jdbc.JdbcEJBQLTranslatorFactory;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.DefaultQuotingStrategy;
import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesHandler;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.resource.ClassLoaderResourceLocator;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcAdapter
implements DbAdapter {
    public static final String CI_PROPERTY = "cayenne.runtime.db.collation.assume.ci";
    private PkGenerator pkGenerator;
    protected QuotingStrategy quotingStrategy;
    protected TypesHandler typesHandler;
    protected ExtendedTypeMap extendedTypes;
    protected boolean supportsBatchUpdates;
    protected boolean supportsUniqueConstraints;
    protected boolean supportsGeneratedKeys;
    protected EJBQLTranslatorFactory ejbqlTranslatorFactory;
    protected ResourceLocator resourceLocator;
    protected boolean caseInsensitiveCollations;
    @Inject
    protected BatchQueryBuilderFactory batchQueryBuilderFactory;
    @Inject
    protected JdbcEventLogger logger;

    public JdbcAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories) {
        this.setSupportsBatchUpdates(false);
        this.setSupportsUniqueConstraints(true);
        this.caseInsensitiveCollations = runtimeProperties.getBoolean(CI_PROPERTY, false);
        this.resourceLocator = new ClassLoaderResourceLocator();
        this.pkGenerator = this.createPkGenerator();
        this.quotingStrategy = this.createQuotingStrategy();
        this.ejbqlTranslatorFactory = this.createEJBQLTranslatorFactory();
        this.typesHandler = TypesHandler.getHandler(this.findResource("/types.xml"));
        this.extendedTypes = new ExtendedTypeMap();
        this.initExtendedTypes(defaultExtendedTypes, userExtendedTypes, extendedTypeFactories);
    }

    @Override
    public String getBatchTerminator() {
        return ";";
    }

    public JdbcEventLogger getJdbcEventLogger() {
        return this.logger;
    }

    protected URL findResource(String name) {
        for (Class<?> adapterClass = this.getClass(); adapterClass != null && JdbcAdapter.class.isAssignableFrom(adapterClass); adapterClass = adapterClass.getSuperclass()) {
            String path = Util.getPackagePath(adapterClass.getName()) + name;
            Collection<Resource> resources = this.resourceLocator.findResources(path);
            if (resources.isEmpty()) continue;
            return resources.iterator().next().getURL();
        }
        return null;
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
    }

    protected void initExtendedTypes(List<ExtendedType> defaultExtendedTypes, List<ExtendedType> userExtendedTypes, List<ExtendedTypeFactory> extendedTypeFactories) {
        for (ExtendedType type : defaultExtendedTypes) {
            this.extendedTypes.registerType(type);
        }
        this.configureExtendedTypes(this.extendedTypes);
        for (ExtendedType type : userExtendedTypes) {
            this.extendedTypes.registerType(type);
        }
        for (ExtendedTypeFactory typeFactory : extendedTypeFactories) {
            this.extendedTypes.addFactory(typeFactory);
        }
    }

    protected PkGenerator createPkGenerator() {
        return new JdbcPkGenerator(this);
    }

    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        JdbcEJBQLTranslatorFactory translatorFactory = new JdbcEJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    @Override
    public PkGenerator getPkGenerator() {
        return this.pkGenerator;
    }

    public void setPkGenerator(PkGenerator pkGenerator) {
        this.pkGenerator = pkGenerator;
    }

    @Override
    public boolean supportsUniqueConstraints() {
        return this.supportsUniqueConstraints;
    }

    public void setSupportsUniqueConstraints(boolean flag) {
        this.supportsUniqueConstraints = flag;
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        StringBuilder buf = new StringBuilder("DROP TABLE ");
        buf.append(this.quotingStrategy.quotedFullyQualifiedName(table));
        return Collections.singleton(buf.toString());
    }

    @Override
    public String createTable(DbEntity entity) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE ");
        sqlBuffer.append(this.quotingStrategy.quotedFullyQualifiedName(entity));
        sqlBuffer.append(" (");
        Iterator<DbAttribute> it = entity.getAttributes().iterator();
        if (it.hasNext()) {
            boolean first = true;
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute column = it.next();
                if (column.getType() == Integer.MAX_VALUE) {
                    throw new CayenneRuntimeException("Undefined type for attribute '" + entity.getFullyQualifiedName() + "." + column.getName() + "'.", new Object[0]);
                }
                this.createTableAppendColumn(sqlBuffer, column);
            }
            this.createTableAppendPKClause(sqlBuffer, entity);
        }
        sqlBuffer.append(')');
        return sqlBuffer.toString();
    }

    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        Iterator<DbAttribute> pkit = entity.getPrimaryKeys().iterator();
        if (pkit.hasNext()) {
            sqlBuffer.append(", PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute at = pkit.next();
                sqlBuffer.append(this.quotingStrategy.quotedName(at));
            }
            sqlBuffer.append(')');
        }
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String[] types = this.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? ((DbEntity)column.getEntity()).getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '" + entityName + "." + column.getName() + "': " + column.getType(), new Object[0]);
        }
        String type = types[0];
        sqlBuffer.append(this.quotingStrategy.quotedName(column));
        sqlBuffer.append(' ').append(type);
        if (TypesMapping.supportsLength(column.getType())) {
            int scale;
            int len = column.getMaxLength();
            int n = scale = TypesMapping.isDecimal(column.getType()) && column.getType() != 6 ? column.getScale() : -1;
            if (scale > len) {
                scale = -1;
            }
            if (len > 0) {
                sqlBuffer.append('(').append(len);
                if (scale >= 0) {
                    sqlBuffer.append(", ").append(scale);
                }
                sqlBuffer.append(')');
            }
        }
        sqlBuffer.append(column.isMandatory() ? " NOT NULL" : " NULL");
    }

    @Override
    public String createUniqueConstraint(DbEntity source, Collection<DbAttribute> columns) {
        if (columns == null || columns.isEmpty()) {
            throw new CayenneRuntimeException("Can't create UNIQUE constraint - no columns specified.", new Object[0]);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("ALTER TABLE ");
        buf.append(this.quotingStrategy.quotedFullyQualifiedName(source));
        buf.append(" ADD UNIQUE (");
        Iterator<DbAttribute> it = columns.iterator();
        DbAttribute first = it.next();
        buf.append(this.quotingStrategy.quotedName(first));
        while (it.hasNext()) {
            DbAttribute next = it.next();
            buf.append(", ");
            buf.append(this.quotingStrategy.quotedName(next));
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String createFkConstraint(DbRelationship rel) {
        DbEntity source = (DbEntity)rel.getSourceEntity();
        StringBuilder buf = new StringBuilder();
        StringBuilder refBuf = new StringBuilder();
        buf.append("ALTER TABLE ");
        buf.append(this.quotingStrategy.quotedFullyQualifiedName(source));
        buf.append(" ADD FOREIGN KEY (");
        boolean first = true;
        for (DbJoin join : rel.getJoins()) {
            if (!first) {
                buf.append(", ");
                refBuf.append(", ");
            } else {
                first = false;
            }
            buf.append(this.quotingStrategy.quotedSourceName(join));
            refBuf.append(this.quotingStrategy.quotedTargetName(join));
        }
        buf.append(") REFERENCES ");
        buf.append(this.quotingStrategy.quotedFullyQualifiedName((DbEntity)rel.getTargetEntity()));
        buf.append(" (").append(refBuf.toString()).append(')');
        return buf.toString();
    }

    @Override
    public String[] externalTypesForJdbcType(int type) {
        return this.typesHandler.externalTypesForJdbcType(type);
    }

    @Override
    public ExtendedTypeMap getExtendedTypes() {
        return this.extendedTypes;
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int scale, boolean allowNulls) {
        DbAttribute attr = new DbAttribute();
        attr.setName(name);
        attr.setType(type);
        attr.setMandatory(!allowNulls);
        if (size >= 0) {
            attr.setMaxLength(size);
        }
        if (scale >= 0) {
            attr.setScale(scale);
        }
        return attr;
    }

    @Override
    public String tableTypeForTable() {
        return "TABLE";
    }

    @Override
    public String tableTypeForView() {
        return "VIEW";
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        QualifierTranslator translator = new QualifierTranslator(queryAssembler);
        translator.setCaseInsensitive(this.caseInsensitiveCollations);
        return translator;
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new JdbcActionBuilder(this, node.getEntityResolver()));
    }

    @Override
    public void bindParameter(PreparedStatement statement, Object object, int pos, int sqlType, int scale) throws SQLException, Exception {
        if (object == null) {
            statement.setNull(pos, sqlType);
        } else {
            ExtendedType typeProcessor = this.getExtendedTypes().getRegisteredType(object.getClass());
            typeProcessor.setJdbcObject(statement, object, pos, sqlType, scale);
        }
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    public void setSupportsBatchUpdates(boolean flag) {
        this.supportsBatchUpdates = flag;
    }

    @Override
    public boolean supportsGeneratedKeys() {
        return this.supportsGeneratedKeys;
    }

    public void setSupportsGeneratedKeys(boolean flag) {
        this.supportsGeneratedKeys = flag;
    }

    public EJBQLTranslatorFactory getEjbqlTranslatorFactory() {
        return this.ejbqlTranslatorFactory;
    }

    public void setEjbqlTranslatorFactory(EJBQLTranslatorFactory ejbqlTranslatorFactory) {
        this.ejbqlTranslatorFactory = ejbqlTranslatorFactory;
    }

    @Override
    public MergerFactory mergerFactory() {
        return new MergerFactory();
    }

    protected QuotingStrategy createQuotingStrategy() {
        return new DefaultQuotingStrategy("\"", "\"");
    }

    @Override
    @Deprecated
    public QuotingStrategy getQuotingStrategy(boolean needQuotes) {
        return this.getQuotingStrategy();
    }

    @Override
    public QuotingStrategy getQuotingStrategy() {
        return this.quotingStrategy;
    }

    public BatchQueryBuilderFactory getBatchQueryBuilderFactory() {
        return this.batchQueryBuilderFactory;
    }

    public void setBatchQueryBuilderFactory(BatchQueryBuilderFactory batchQueryBuilderFactory) {
        this.batchQueryBuilderFactory = batchQueryBuilderFactory;
    }
}

