/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.NamedObjectFactory;

class ManyToManyCandidateEntity {
    private ObjEntity entity;

    public ManyToManyCandidateEntity(ObjEntity entityValue) {
        this.entity = entityValue;
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    private boolean isTargetEntitiesDifferent() {
        return !this.getTargetEntity1().equals(this.getTargetEntity2());
    }

    private boolean isRelationshipsHasDependentPK() {
        boolean isRelationship1HasDepPK = this.getDbRelationship1().getReverseRelationship().isToDependentPK();
        boolean isRelationship2HasDepPK = this.getDbRelationship2().getReverseRelationship().isToDependentPK();
        return isRelationship1HasDepPK && isRelationship2HasDepPK;
    }

    private ObjRelationship getRelationship1() {
        ArrayList<ObjRelationship> relationships = new ArrayList<ObjRelationship>(this.entity.getRelationships());
        return (ObjRelationship)relationships.get(0);
    }

    private ObjRelationship getRelationship2() {
        ArrayList<ObjRelationship> relationships = new ArrayList<ObjRelationship>(this.entity.getRelationships());
        return (ObjRelationship)relationships.get(1);
    }

    private ObjEntity getTargetEntity1() {
        return (ObjEntity)this.getRelationship1().getTargetEntity();
    }

    private ObjEntity getTargetEntity2() {
        return (ObjEntity)this.getRelationship2().getTargetEntity();
    }

    private DbRelationship getDbRelationship1() {
        return this.getRelationship1().getDbRelationships().get(0);
    }

    private DbRelationship getDbRelationship2() {
        return this.getRelationship2().getDbRelationships().get(0);
    }

    public boolean isRepresentManyToManyTable() {
        boolean hasTwoRelationships = this.entity.getRelationships().size() == 2;
        boolean isNotHaveAttributes = this.entity.getAttributes().size() == 0;
        return hasTwoRelationships && isNotHaveAttributes && this.isRelationshipsHasDependentPK() && this.isTargetEntitiesDifferent();
    }

    private void removeRelationshipsFromTargetEntities() {
        this.getTargetEntity1().removeRelationship(this.getRelationship1().getReverseRelationship().getName());
        this.getTargetEntity2().removeRelationship(this.getRelationship2().getReverseRelationship().getName());
    }

    private void addFlattenedRelationship(ObjEntity srcEntity, ObjEntity dstEntity, DbRelationship ... relationshipPath) {
        ObjRelationship newRelationship = (ObjRelationship)NamedObjectFactory.createRelationship(srcEntity, dstEntity, true);
        newRelationship.setSourceEntity(srcEntity);
        newRelationship.setTargetEntity(dstEntity);
        for (DbRelationship curRelationship : relationshipPath) {
            newRelationship.addDbRelationship(curRelationship);
        }
        srcEntity.addRelationship(newRelationship);
    }

    public void optimizeRelationships() {
        this.removeRelationshipsFromTargetEntities();
        DbRelationship dbRelationship1 = this.getRelationship1().getDbRelationships().get(0);
        DbRelationship dbRelationship2 = this.getRelationship2().getDbRelationships().get(0);
        this.addFlattenedRelationship(this.getTargetEntity1(), this.getTargetEntity2(), dbRelationship1.getReverseRelationship(), dbRelationship2);
        this.addFlattenedRelationship(this.getTargetEntity2(), this.getTargetEntity1(), dbRelationship2.getReverseRelationship(), dbRelationship1);
    }
}

