/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.spi.ConstructorInjectingProvider;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAdhocObjectFactory
implements AdhocObjectFactory {
    @Inject
    protected Injector injector;

    @Override
    public <T> T newInstance(Class<? super T> superType, String className) {
        Object instance;
        Class<?> type;
        if (superType == null) {
            throw new NullPointerException("Null superType");
        }
        if (className == null) {
            throw new NullPointerException("Null className");
        }
        try {
            type = this.getJavaClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Invalid class %s of type %s", (Throwable)e, className, superType.getName());
        }
        if (!superType.isAssignableFrom(type)) {
            throw new CayenneRuntimeException("Class %s is not assignable to %s", className, superType.getName());
        }
        try {
            ConstructorInjectingProvider provider0 = new ConstructorInjectingProvider(type, (DefaultInjector)this.injector);
            FieldInjectingProvider provider1 = new FieldInjectingProvider(provider0, (DefaultInjector)this.injector);
            instance = provider1.get();
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error creating instance of class %s of type %s", (Throwable)e, className, superType.getName());
        }
        return instance;
    }

    public Class<?> getJavaClass(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new ClassNotFoundException("Null class name");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = DefaultAdhocObjectFactory.class.getClassLoader();
        }
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            if (!className.endsWith("[]")) {
                if ("byte".equals(className)) {
                    return Byte.TYPE;
                }
                if ("int".equals(className)) {
                    return Integer.TYPE;
                }
                if ("short".equals(className)) {
                    return Short.TYPE;
                }
                if ("char".equals(className)) {
                    return Character.TYPE;
                }
                if ("double".equals(className)) {
                    return Double.TYPE;
                }
                if ("long".equals(className)) {
                    return Long.TYPE;
                }
                if ("float".equals(className)) {
                    return Float.TYPE;
                }
                if ("boolean".equals(className)) {
                    return Boolean.TYPE;
                }
                int dot = className.lastIndexOf(46);
                if (dot > 0 && dot + 1 < className.length()) {
                    className = className.substring(0, dot) + "$" + className.substring(dot + 1);
                    try {
                        return Class.forName(className, true, classLoader);
                    }
                    catch (ClassNotFoundException nestedE) {
                        // empty catch block
                    }
                }
                throw e;
            }
            if (className.length() < 3) {
                throw new IllegalArgumentException("Invalid class name: " + className);
            }
            if ("byte".equals(className = className.substring(0, className.length() - 2))) {
                return byte[].class;
            }
            if ("int".equals(className)) {
                return int[].class;
            }
            if ("long".equals(className)) {
                return long[].class;
            }
            if ("short".equals(className)) {
                return short[].class;
            }
            if ("char".equals(className)) {
                return char[].class;
            }
            if ("double".equals(className)) {
                return double[].class;
            }
            if ("float".equals(className)) {
                return float[].class;
            }
            if ("boolean".equals(className)) {
                return boolean[].class;
            }
            return Class.forName("[L" + className + ";", true, classLoader);
        }
    }
}

