/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.cayenne.configuration.server.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.DbAdapterFactory;
import org.apache.cayenne.dba.mysql.MySQLAdapter;

public class MySQLSniffer
implements DbAdapterFactory,
DbAdapterDetector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String dbName = md.getDatabaseProductName();
        if (dbName == null || !dbName.toUpperCase().contains("MYSQL")) {
            return null;
        }
        Statement statement = md.getConnection().createStatement();
        boolean supportFK = false;
        String adapterStorageEngine = "InnoDB";
        try {
            ResultSet rs = statement.executeQuery("SHOW VARIABLES LIKE 'table_type'");
            try {
                String storageEngine;
                if (rs.next() && (storageEngine = rs.getString(2)) != null) {
                    adapterStorageEngine = storageEngine;
                    supportFK = storageEngine.toUpperCase().equals("INNODB");
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        MySQLAdapter adapter = new MySQLAdapter();
        adapter.setSupportsFkConstraints(supportFK);
        adapter.setStorageEngine(adapterStorageEngine);
        return adapter;
    }
}

