/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.util.Map;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRuntimeProperties
implements RuntimeProperties {
    public static final String PROPERTIES_MAP = "org.apache.cayenne.configuration.DefaultRuntimeProperties.properties";
    protected Map<String, String> properties;

    public DefaultRuntimeProperties(@Inject(value="org.apache.cayenne.configuration.DefaultRuntimeProperties.properties") Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public String get(String key) {
        String property = System.getProperty(key);
        if (property != null) {
            return property;
        }
        return this.properties.get(key);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String string = this.get(key);
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        String string = this.get(key);
        return string != null ? "true".equalsIgnoreCase(string) : defaultValue;
    }
}

