/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.DataChannelSyncCallbackAction;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataDomainLegacyQueryAction;
import org.apache.cayenne.access.DataDomainQueryAction;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DomainStoppedException;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.access.TransactionDelegate;
import org.apache.cayenne.access.jdbc.BatchQueryBuilderFactory;
import org.apache.cayenne.cache.NestedQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryChain;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDomain
implements QueryEngine,
DataChannel {
    public static final String SHARED_CACHE_ENABLED_PROPERTY = "cayenne.DataDomain.sharedCache";
    public static final boolean SHARED_CACHE_ENABLED_DEFAULT = true;
    public static final String VALIDATING_OBJECTS_ON_COMMIT_PROPERTY = "cayenne.DataDomain.validatingObjectsOnCommit";
    public static final boolean VALIDATING_OBJECTS_ON_COMMIT_DEFAULT = true;
    public static final String USING_EXTERNAL_TRANSACTIONS_PROPERTY = "cayenne.DataDomain.usingExternalTransactions";
    public static final boolean USING_EXTERNAL_TRANSACTIONS_DEFAULT = false;
    @Inject
    protected JdbcEventLogger jdbcEventLogger;
    protected List<DataChannelFilter> filters;
    protected Map<String, DataNode> nodes = Collections.synchronizedMap(new TreeMap());
    protected Map<String, DataNode> nodesByDataMapName = Collections.synchronizedMap(new HashMap());
    protected Map<String, String> properties = Collections.synchronizedMap(new TreeMap());
    protected EntityResolver entityResolver;
    protected DataRowStore sharedSnapshotCache;
    protected TransactionDelegate transactionDelegate;
    protected String name;
    protected QueryCache queryCache;
    protected boolean sharedCacheEnabled;
    protected boolean validatingObjectsOnCommit;
    protected boolean usingExternalTransactions;
    protected EventManager eventManager;
    protected EntitySorter entitySorter;
    protected boolean stopped;
    private BatchQueryBuilderFactory queryBuilderFactory;

    public DataDomain(String name) {
        this.filters = new CopyOnWriteArrayList<DataChannelFilter>();
        this.setName(name);
        this.resetProperties();
    }

    public DataDomain(String name, Map properties) {
        this.filters = new CopyOnWriteArrayList<DataChannelFilter>();
        this.setName(name);
        this.initWithProperties(properties);
    }

    protected void checkStopped() throws DomainStoppedException {
        if (this.stopped) {
            throw new DomainStoppedException("Domain " + this.name + " was shutdown and can no longer be used to access the database", new Object[0]);
        }
    }

    public EntitySorter getEntitySorter() {
        return this.entitySorter;
    }

    public void setEntitySorter(EntitySorter entitySorter) {
        this.entitySorter = entitySorter;
    }

    protected void resetProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
        this.sharedCacheEnabled = true;
        this.validatingObjectsOnCommit = true;
        this.usingExternalTransactions = false;
    }

    public void initWithProperties(Map<String, String> properties) {
        HashMap<String, String> localMap = new HashMap<String, String>();
        if (properties != null) {
            localMap.putAll(properties);
        }
        this.properties = localMap;
        String sharedCacheEnabled = (String)localMap.get(SHARED_CACHE_ENABLED_PROPERTY);
        String validatingObjectsOnCommit = (String)localMap.get(VALIDATING_OBJECTS_ON_COMMIT_PROPERTY);
        String usingExternalTransactions = (String)localMap.get(USING_EXTERNAL_TRANSACTIONS_PROPERTY);
        this.sharedCacheEnabled = sharedCacheEnabled != null ? "true".equalsIgnoreCase(sharedCacheEnabled) : true;
        this.validatingObjectsOnCommit = validatingObjectsOnCommit != null ? "true".equalsIgnoreCase(validatingObjectsOnCommit) : true;
        this.usingExternalTransactions = usingExternalTransactions != null ? "true".equalsIgnoreCase(usingExternalTransactions) : false;
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
        if (this.sharedSnapshotCache != null) {
            this.sharedSnapshotCache.setEventManager(eventManager);
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
        if (this.sharedSnapshotCache != null) {
            this.sharedSnapshotCache.setName(name);
        }
    }

    public boolean isSharedCacheEnabled() {
        return this.sharedCacheEnabled;
    }

    public void setSharedCacheEnabled(boolean sharedCacheEnabled) {
        this.sharedCacheEnabled = sharedCacheEnabled;
    }

    public boolean isValidatingObjectsOnCommit() {
        return this.validatingObjectsOnCommit;
    }

    public void setValidatingObjectsOnCommit(boolean flag) {
        this.validatingObjectsOnCommit = flag;
    }

    public boolean isUsingExternalTransactions() {
        return this.usingExternalTransactions;
    }

    public void setUsingExternalTransactions(boolean flag) {
        this.usingExternalTransactions = flag;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public TransactionDelegate getTransactionDelegate() {
        return this.transactionDelegate;
    }

    public void setTransactionDelegate(TransactionDelegate transactionDelegate) {
        this.transactionDelegate = transactionDelegate;
    }

    public synchronized DataRowStore getSharedSnapshotCache() {
        if (this.sharedSnapshotCache == null && this.sharedCacheEnabled) {
            this.sharedSnapshotCache = new DataRowStore(this.name, this.properties, this.eventManager);
        }
        return this.sharedSnapshotCache;
    }

    synchronized DataRowStore nonNullSharedSnapshotCache() {
        if (this.sharedSnapshotCache == null) {
            this.sharedSnapshotCache = new DataRowStore(this.name, this.properties, this.eventManager);
        }
        return this.sharedSnapshotCache;
    }

    public synchronized void setSharedSnapshotCache(DataRowStore snapshotCache) {
        if (this.sharedSnapshotCache != snapshotCache) {
            if (this.sharedSnapshotCache != null) {
                this.sharedSnapshotCache.shutdown();
            }
            this.sharedSnapshotCache = snapshotCache;
            if (snapshotCache != null) {
                snapshotCache.setEventManager(this.getEventManager());
                snapshotCache.setName(this.getName());
            }
        }
    }

    public void addMap(DataMap map) {
        this.addDataMap(map);
    }

    public void addDataMap(DataMap dataMap) {
        this.getEntityResolver().addDataMap(dataMap);
        this.refreshEntitySorter();
    }

    public DataMap getMap(String mapName) {
        return this.getEntityResolver().getDataMap(mapName);
    }

    public DataMap getDataMap(String mapName) {
        return this.getEntityResolver().getDataMap(mapName);
    }

    public void removeMap(String mapName) {
        this.removeDataMap(mapName);
    }

    public synchronized void removeDataMap(String mapName) {
        DataMap map = this.getDataMap(mapName);
        if (map == null) {
            return;
        }
        for (DataNode node : this.nodes.values()) {
            node.removeDataMap(mapName);
        }
        this.getEntityResolver().removeDataMap(map);
        this.reindexNodes();
        this.refreshEntitySorter();
    }

    public synchronized void removeDataNode(String nodeName) {
        DataNode removed = this.nodes.remove(nodeName);
        if (removed != null) {
            removed.setEntityResolver(null);
            Iterator<DataNode> it = this.nodesByDataMapName.values().iterator();
            while (it.hasNext()) {
                if (it.next() != removed) continue;
                it.remove();
            }
        }
    }

    public Collection<DataMap> getDataMaps() {
        return this.getEntityResolver().getDataMaps();
    }

    public Collection<DataNode> getDataNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<String, DataNode> map = this.nodes;
        synchronized (map) {
            this.nodes.clear();
            this.nodesByDataMapName.clear();
            if (this.entityResolver != null) {
                this.entityResolver.clearCache();
                this.entityResolver = null;
            }
        }
    }

    public void clearDataMaps() {
        this.getEntityResolver().setDataMaps(Collections.EMPTY_LIST);
    }

    public synchronized void addNode(DataNode node) {
        this.nodes.put(node.getName(), node);
        node.setEntityResolver(this.getEntityResolver());
        for (DataMap map : node.getDataMaps()) {
            this.addDataMap(map);
            this.nodesByDataMapName.put(map.getName(), node);
        }
    }

    @Deprecated
    public DataContext createDataContext() {
        return this.createDataContext(this.isSharedCacheEnabled());
    }

    @Deprecated
    public DataContext createDataContext(boolean useSharedCache) {
        DataRowStore snapshotCache = useSharedCache ? this.nonNullSharedSnapshotCache() : new DataRowStore(this.name, this.properties, this.eventManager);
        DataContext context = new DataContext(this, new ObjectStore(snapshotCache));
        if (this.queryCache != null) {
            context.setQueryCache(new NestedQueryCache(this.queryCache));
        }
        context.setValidatingObjectsOnCommit(this.isValidatingObjectsOnCommit());
        return context;
    }

    public Transaction createTransaction() {
        if (this.isUsingExternalTransactions()) {
            Transaction transaction = Transaction.externalTransaction(this.getTransactionDelegate());
            transaction.setJdbcEventLogger(this.jdbcEventLogger);
            return transaction;
        }
        Transaction transaction = Transaction.internalTransaction(this.getTransactionDelegate());
        transaction.setJdbcEventLogger(this.jdbcEventLogger);
        return transaction;
    }

    public DataNode getNode(String nodeName) {
        return this.nodes.get(nodeName);
    }

    public synchronized void reindexNodes() {
        this.nodesByDataMapName.clear();
        for (DataNode node : this.getDataNodes()) {
            for (DataMap map : node.getDataMaps()) {
                this.addDataMap(map);
                this.nodesByDataMapName.put(map.getName(), node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataNode lookupDataNode(DataMap map) {
        Map<String, DataNode> map2 = this.nodesByDataMapName;
        synchronized (map2) {
            DataNode node = this.nodesByDataMapName.get(map.getName());
            if (node == null) {
                this.reindexNodes();
                return this.nodesByDataMapName.get(map.getName());
            }
            return node;
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    private synchronized void createEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = new EntityResolver();
        }
    }

    @BeforeScopeEnd
    public void shutdown() {
        if (!this.stopped) {
            this.stopped = true;
            if (this.sharedSnapshotCache != null) {
                this.sharedSnapshotCache.shutdown();
            }
            for (DataNode node : this.getDataNodes()) {
                node.shutdown();
            }
        }
    }

    @Override
    public void performQueries(final Collection<? extends Query> queries, final OperationObserver callback) {
        this.runInTransaction(new Transformer(){

            public Object transform(Object input) {
                new DataDomainLegacyQueryAction(DataDomain.this, new QueryChain(queries), callback).execute();
                return null;
            }
        });
    }

    @Override
    public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
        this.checkStopped();
        return new DataDomainQueryFilterChain().onQuery(originatingContext, query);
    }

    QueryResponse onQueryNoFilters(ObjectContext originatingContext, Query query) {
        return new DataDomainQueryAction(originatingContext, this, query).execute();
    }

    @Override
    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            this.createEntityResolver();
        }
        return this.entityResolver;
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        this.checkStopped();
        return new DataDomainSyncFilterChain().onSync(originatingContext, changes, syncType);
    }

    GraphDiff onSyncNoFilters(final ObjectContext originatingContext, final GraphDiff changes, int syncType) {
        GraphDiff result;
        DataChannelSyncCallbackAction callbackAction = DataChannelSyncCallbackAction.getCallbackAction(this.getEntityResolver().getCallbackRegistry(), originatingContext.getGraphManager(), changes, syncType);
        callbackAction.applyPreCommit();
        switch (syncType) {
            case 3: {
                result = this.onSyncRollback(originatingContext);
                break;
            }
            case 1: 
            case 2: {
                result = (GraphDiff)this.runInTransaction(new Transformer(){

                    public Object transform(Object input) {
                        return DataDomain.this.onSyncFlush(originatingContext, changes);
                    }
                });
                break;
            }
            default: {
                throw new CayenneRuntimeException("Invalid synchronization type: " + syncType, new Object[0]);
            }
        }
        callbackAction.applyPostCommit();
        return result;
    }

    GraphDiff onSyncRollback(ObjectContext originatingContext) {
        Transaction transaction = Transaction.getThreadTransaction();
        if (transaction != null) {
            transaction.setRollbackOnly();
        }
        return new CompoundDiff();
    }

    GraphDiff onSyncFlush(ObjectContext originatingContext, GraphDiff childChanges) {
        if (!(originatingContext instanceof DataContext)) {
            throw new CayenneRuntimeException("No support for committing ObjectContexts that are not DataContexts yet. Unsupported context: " + originatingContext, new Object[0]);
        }
        DataDomainFlushAction action = new DataDomainFlushAction(this);
        action.setJdbcEventLogger(this.jdbcEventLogger);
        return action.flush((DataContext)originatingContext, childChanges);
    }

    Object runInTransaction(Transformer operation) {
        if (Transaction.getThreadTransaction() != null) {
            return operation.transform(null);
        }
        Transaction transaction = this.createTransaction();
        Transaction.bindThreadTransaction(transaction);
        try {
            Object result = operation.transform(null);
            transaction.commit();
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            transaction.setRollbackOnly();
            if (ex instanceof CayenneRuntimeException) {
                throw (CayenneRuntimeException)ex;
            }
            throw new CayenneRuntimeException(ex);
        }
        finally {
            Transaction.bindThreadTransaction(null);
            if (transaction.getStatus() == 7) {
                try {
                    transaction.rollback();
                }
                catch (Exception rollbackEx) {
                    this.jdbcEventLogger.logQueryError(rollbackEx);
                }
            }
        }
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).toString();
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    public void setQueryBuilderFactory(BatchQueryBuilderFactory queryBuilderFactory) {
        this.queryBuilderFactory = queryBuilderFactory;
    }

    public BatchQueryBuilderFactory getQueryBuilderFactory() {
        return this.queryBuilderFactory;
    }

    JdbcEventLogger getJdbcEventLogger() {
        return this.jdbcEventLogger;
    }

    void refreshEntitySorter() {
        if (this.entitySorter != null) {
            this.entitySorter.setEntityResolver(this.getEntityResolver());
        }
    }

    public List<DataChannelFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void addFilter(DataChannelFilter filter) {
        filter.init(this);
        this.filters.add(filter);
    }

    public void removeFilter(DataChannelFilter filter) {
        this.filters.remove(filter);
    }

    final class DataDomainSyncFilterChain
    extends DataDomainFilterChain {
        DataDomainSyncFilterChain() {
        }

        public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
            DataChannelFilter filter = this.nextFilter();
            return filter != null ? filter.onSync(originatingContext, changes, syncType, this) : DataDomain.this.onSyncNoFilters(originatingContext, changes, syncType);
        }

        public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
            throw new UnsupportedOperationException("It is illegal to call 'onQuery' inside 'onSync' chain");
        }
    }

    final class DataDomainQueryFilterChain
    extends DataDomainFilterChain {
        DataDomainQueryFilterChain() {
        }

        public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
            DataChannelFilter filter = this.nextFilter();
            return filter != null ? filter.onQuery(originatingContext, query, this) : DataDomain.this.onQueryNoFilters(originatingContext, query);
        }

        public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
            throw new UnsupportedOperationException("It is illegal to call 'onSync' inside 'onQuery' chain");
        }
    }

    abstract class DataDomainFilterChain
    implements DataChannelFilterChain {
        private int i;

        DataDomainFilterChain() {
            this.i = DataDomain.this.filters != null ? DataDomain.this.filters.size() : 0;
        }

        DataChannelFilter nextFilter() {
            --this.i;
            return this.i >= 0 ? DataDomain.this.filters.get(this.i) : null;
        }
    }
}

