/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.CayenneContext;
import org.apache.cayenne.CayenneContextGraphManager;
import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.util.Util;

class CayenneContextMergeHandler
implements GraphChangeHandler,
DataChannelListener {
    CayenneContext context;
    boolean active;

    CayenneContextMergeHandler(CayenneContext context) {
        this.context = context;
        this.active = true;
    }

    public void graphChanged(final GraphEvent e) {
        if (this.shouldProcessEvent(e) && e.getDiff() != null) {
            this.runWithEventsDisabled(new Runnable(){

                public void run() {
                    e.getDiff().apply(CayenneContextMergeHandler.this);
                }
            });
            this.repostAfterMerge(e);
        }
    }

    public void graphFlushed(final GraphEvent e) {
        if (this.shouldProcessEvent(e)) {
            this.runWithEventsDisabled(new Runnable(){

                public void run() {
                    if (e.getDiff() != null) {
                        e.getDiff().apply(CayenneContextMergeHandler.this);
                    }
                }
            });
            this.repostAfterMerge(e);
        }
    }

    public void graphRolledback(GraphEvent e) {
    }

    void repostAfterMerge(GraphEvent originalEvent) {
        if (this.context.isLifecycleEventsEnabled()) {
            this.context.fireDataChannelChanged(originalEvent.getSource(), originalEvent.getDiff());
        }
    }

    void merge(final GraphDiff diff) {
        this.runWithEventsDisabled(new Runnable(){

            public void run() {
                diff.apply(CayenneContextMergeHandler.this);
            }
        });
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        Object node = this.context.internalGraphManager().getNode(nodeId);
        if (node != null) {
            this.context.internalGraphManager().deadIds().add(nodeId);
            this.context.internalGraphManager().registerNode(newId, node);
            if (node instanceof Persistent) {
                ((Persistent)node).setObjectId((ObjectId)newId);
            }
        }
    }

    public void nodeCreated(Object nodeId) {
    }

    public void nodeRemoved(Object nodeId) {
        this.context.getGraphManager().unregisterNode(nodeId);
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        Property p;
        Object object = this.context.internalGraphManager().getNode(nodeId);
        if (object != null && Util.nullSafeEquals((p = this.propertyForId(nodeId, property)).readPropertyDirectly(object), oldValue)) {
            p.writePropertyDirectly(object, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        Object source = this.context.internalGraphManager().getNode(nodeId);
        if (source == null) {
            return;
        }
        ArcProperty p = (ArcProperty)this.propertyForId(nodeId, arcId.toString());
        if (p.isFault(source)) {
            return;
        }
        Object target = this.context.internalGraphManager().getNode(targetNodeId);
        if (target == null) {
            target = this.context.createFault((ObjectId)targetNodeId);
        }
        if (p instanceof ToManyProperty) {
            ((ToManyProperty)p).addTargetDirectly(source, target);
        } else {
            p.writePropertyDirectly(source, null, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        Object source = this.context.internalGraphManager().getNode(nodeId);
        if (source == null) {
            return;
        }
        ArcProperty p = (ArcProperty)this.propertyForId(nodeId, arcId.toString());
        if (p.isFault(source)) {
            return;
        }
        Object target = this.context.internalGraphManager().getNode(targetNodeId);
        if (target == null) {
            target = this.context.createFault((ObjectId)targetNodeId);
        }
        if (p instanceof ToManyProperty) {
            ((ToManyProperty)p).removeTargetDirectly(source, target);
        } else {
            p.writePropertyDirectly(source, target, null);
        }
    }

    private Property propertyForId(Object nodeId, String propertyName) {
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        return descriptor.getProperty(propertyName);
    }

    boolean shouldProcessEvent(GraphEvent e) {
        return this.active && e.getSource() == this.context.getChannel() && e.getPostedBy() != this.context && e.getPostedBy() != this.context.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithEventsDisabled(Runnable closure) {
        CayenneContextGraphManager cayenneContextGraphManager = this.context.internalGraphManager();
        synchronized (cayenneContextGraphManager) {
            boolean changeEventsEnabled = this.context.internalGraphManager().changeEventsEnabled;
            this.context.internalGraphManager().changeEventsEnabled = false;
            boolean lifecycleEventsEnabled = this.context.internalGraphManager().lifecycleEventsEnabled;
            this.context.internalGraphManager().lifecycleEventsEnabled = false;
            try {
                closure.run();
            }
            finally {
                this.context.internalGraphManager().changeEventsEnabled = changeEventsEnabled;
                this.context.internalGraphManager().lifecycleEventsEnabled = lifecycleEventsEnabled;
            }
        }
    }
}

