/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAdhocObjectFactory
implements AdhocObjectFactory {
    @Inject
    protected Injector injector;

    @Override
    public <T> T newInstance(Class<? super T> superType, String className) {
        Object instance;
        Class<?> type;
        if (superType == null) {
            throw new NullPointerException("Null superType");
        }
        if (className == null) {
            throw new NullPointerException("Null className");
        }
        try {
            type = Util.getJavaClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Invalid class %s of type %s", (Throwable)e, className, superType.getName());
        }
        if (!superType.isAssignableFrom(type)) {
            throw new CayenneRuntimeException("Class %s is not assignable to %s", className, superType.getName());
        }
        try {
            instance = type.newInstance();
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error creating instance of class %s of type %s", (Throwable)e, className, superType.getName());
        }
        this.injector.injectMembers(instance);
        return (T)instance;
    }
}

