/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.parser.ASTNot;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ExpressionParserTreeConstants;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleNode
extends Expression
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;

    protected static void encodeScalarAsString(PrintWriter pw, Object scalar, char quoteChar) {
        ObjectId id;
        boolean quote = scalar instanceof String;
        if (quote) {
            pw.print(quoteChar);
        }
        if (scalar instanceof Persistent && (id = ((Persistent)scalar).getObjectId()) != null) {
            scalar = id;
        }
        SimpleNode.encodeAsEscapedString(pw, String.valueOf(scalar));
        if (quote) {
            pw.print(quoteChar);
        }
    }

    protected static void encodeAsEscapedString(PrintWriter pw, String source) {
        int len = source.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\n': {
                    pw.print("\\n");
                    continue block10;
                }
                case '\r': {
                    pw.print("\\r");
                    continue block10;
                }
                case '\t': {
                    pw.print("\\t");
                    continue block10;
                }
                case '\b': {
                    pw.print("\\b");
                    continue block10;
                }
                case '\f': {
                    pw.print("\\f");
                    continue block10;
                }
                case '\\': {
                    pw.print("\\\\");
                    continue block10;
                }
                case '\'': {
                    pw.print("\\'");
                    continue block10;
                }
                case '\"': {
                    pw.print("\\\"");
                    continue block10;
                }
                default: {
                    pw.print(c);
                }
            }
        }
    }

    protected SimpleNode(int i) {
        this.id = i;
    }

    @Override
    public Map<String, String> getPathAliases() {
        return Collections.emptyMap();
    }

    protected abstract String getExpressionOperator(int var1);

    protected String getEJBQLExpressionOperator(int index) {
        return this.getExpressionOperator(index);
    }

    @Override
    protected boolean pruneNodeForPrunedChild(Object prunedChild) {
        return true;
    }

    @Override
    public String expName() {
        return ExpressionParserTreeConstants.jjtNodeName[this.id];
    }

    @Override
    protected void flattenTree() {
        boolean shouldFlatten = false;
        int newSize = 0;
        for (Node child : this.children) {
            if (child.getClass() == this.getClass()) {
                shouldFlatten = true;
                newSize += child.jjtGetNumChildren();
                continue;
            }
            ++newSize;
        }
        if (shouldFlatten) {
            Node[] newChildren = new Node[newSize];
            int j = 0;
            for (Node c : this.children) {
                if (c.getClass() == this.getClass()) {
                    for (int k = 0; k < c.jjtGetNumChildren(); ++k) {
                        newChildren[j++] = c.jjtGetChild(k);
                    }
                    continue;
                }
                newChildren[j++] = c;
            }
            if (j != newSize) {
                throw new ExpressionException("Assertion error: " + j + " != " + newSize, new Object[0]);
            }
            this.children = newChildren;
        }
    }

    @Override
    public void encodeAsString(PrintWriter pw) {
        if (this.parent != null) {
            pw.print("(");
        }
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (i > 0) {
                    pw.print(' ');
                    pw.print(this.getExpressionOperator(i));
                    pw.print(' ');
                }
                if (this.children[i] == null) {
                    pw.print("null");
                    continue;
                }
                ((SimpleNode)this.children[i]).encodeAsString(pw);
            }
        }
        if (this.parent != null) {
            pw.print(')');
        }
    }

    @Override
    public Object getOperand(int index) {
        Node child = this.jjtGetChild(index);
        return this.unwrapChild(child);
    }

    protected Node wrapChild(Object child) {
        return child instanceof Node || child == null ? (Node)child : new ASTScalar(child);
    }

    protected Object unwrapChild(Node child) {
        return child instanceof ASTScalar ? ((ASTScalar)child).getValue() : child;
    }

    @Override
    public int getOperandCount() {
        return this.jjtGetNumChildren();
    }

    @Override
    public void setOperand(int index, Object value) {
        Node node = value == null || value instanceof Node ? (Node)value : new ASTScalar(value);
        this.jjtAddChild(node, index);
        if (node != null) {
            node.jjtSetParent(this);
        }
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public final int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    protected abstract Object evaluateNode(Object var1) throws Exception;

    protected void connectChildren() {
        if (this.children != null) {
            for (Node child : this.children) {
                if (child == null) continue;
                child.jjtSetParent(this);
            }
        }
    }

    protected Object evaluateChild(int index, Object o) throws Exception {
        SimpleNode node = (SimpleNode)this.jjtGetChild(index);
        return node != null ? node.evaluate(o) : null;
    }

    @Override
    public Expression notExp() {
        return new ASTNot(this);
    }

    @Override
    public Object evaluate(Object o) {
        try {
            return this.evaluateNode(o);
        }
        catch (Throwable th) {
            String string = this.toString();
            throw new ExpressionException("Error evaluating expression '" + string + "'", string, Util.unwindException(th), new Object[0]);
        }
    }

    @Override
    public void encodeAsEJBQL(PrintWriter pw, String rootId) {
        if (this.parent != null) {
            pw.print("(");
        }
        if (this.children != null && this.children.length > 0) {
            this.encodeChildrenAsEJBQL(pw, rootId);
        }
        if (this.parent != null) {
            pw.print(')');
        }
    }

    protected void encodeChildrenAsEJBQL(PrintWriter pw, String rootId) {
        for (int i = 0; i < this.children.length; ++i) {
            if (i > 0) {
                pw.print(' ');
                pw.print(this.getEJBQLExpressionOperator(i));
                pw.print(' ');
            }
            if (this.children[i] == null) {
                pw.print("null");
                continue;
            }
            ((SimpleNode)this.children[i]).encodeAsEJBQL(pw, rootId);
        }
    }
}

