/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sybase;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.cayenne.access.jdbc.EJBQLTranslatorFactory;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.sybase.SybaseEJBQLTranslatorFactory;
import org.apache.cayenne.dba.sybase.SybaseMergerFactory;
import org.apache.cayenne.dba.sybase.SybasePkGenerator;
import org.apache.cayenne.merge.MergerFactory;

public class SybaseAdapter
extends JdbcAdapter {
    static final String MYSQL_QUOTE_SQL_IDENTIFIERS_CHAR_START = "[";
    static final String MYSQL_QUOTE_SQL_IDENTIFIERS_CHAR_END = "]";

    public void initIdentifiersQuotes() {
        this.identifiersStartQuote = MYSQL_QUOTE_SQL_IDENTIFIERS_CHAR_START;
        this.identifiersEndQuote = MYSQL_QUOTE_SQL_IDENTIFIERS_CHAR_END;
    }

    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        return new SybaseEJBQLTranslatorFactory();
    }

    public String getBatchTerminator() {
        return "go";
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, false));
        map.registerType(new ByteArrayType(true, false));
        map.registerType(new ShortType(true));
        map.registerType(new ByteType(true));
    }

    protected PkGenerator createPkGenerator() {
        return new SybasePkGenerator(this);
    }

    public void bindParameter(PreparedStatement statement, Object object, int pos, int sqlType, int precision) throws SQLException, Exception {
        if (object == null) {
            if (sqlType == 2005) {
                sqlType = 12;
            } else if (sqlType == 2004) {
                sqlType = -3;
            }
        }
        if (object == null && sqlType == 0) {
            statement.setNull(pos, 12);
        } else {
            super.bindParameter(statement, object, pos, sqlType, precision);
        }
    }

    public MergerFactory mergerFactory() {
        return new SybaseMergerFactory();
    }
}

