/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.lang.reflect.Method;
import java.net.URL;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.dba.oracle.Oracle8ActionBuilder;
import org.apache.cayenne.dba.oracle.Oracle8QualifierTranslator;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

public class Oracle8Adapter
extends OracleAdapter {
    private static Method outputStreamFromBlobMethod;
    private static Method writerFromClobMethod;

    private static void initOracle8DriverInformation() {
        initDone = true;
        try {
            outputStreamFromBlobMethod = Class.forName("oracle.sql.BLOB").getMethod("getBinaryOutputStream", new Class[0]);
            writerFromClobMethod = Class.forName("oracle.sql.CLOB").getMethod("getCharacterOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static Method getWriterFromClobMethod() {
        return writerFromClobMethod;
    }

    static Method getOutputStreamFromBlobMethod() {
        return outputStreamFromBlobMethod;
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new Oracle8ActionBuilder(this, node.getEntityResolver()));
    }

    protected URL findResource(String name) {
        if ("/types.xml".equals(name)) {
            name = "/types-oracle8.xml";
        }
        return super.findResource(name);
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new Oracle8QualifierTranslator(queryAssembler);
    }

    static {
        Oracle8Adapter.initOracle8DriverInformation();
    }
}

