/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.AdhocObjectFactory;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DataSourceFactoryLoader;
import org.apache.cayenne.configuration.server.PropertyDataSourceFactory;
import org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory;
import org.apache.cayenne.di.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDataSourceFactoryLoader
implements DataSourceFactoryLoader {
    private static final Log logger = LogFactory.getLog(DefaultDataSourceFactoryLoader.class);
    @Inject
    protected AdhocObjectFactory objectFactory;

    public DataSourceFactory getDataSourceFactory(DataNodeDescriptor nodeDescriptor) {
        String typeName = null;
        typeName = this.shouldConfigureDataSourceFromProperties(nodeDescriptor) ? PropertyDataSourceFactory.class.getName() : nodeDescriptor.getDataSourceFactoryType();
        if (typeName == null) {
            if (nodeDescriptor.getDataSourceDescriptor() == null) {
                throw new CayenneRuntimeException("DataNodeDescriptor '%s' has null 'dataSourceFactoryType' and 'dataSourceDescriptor' properties", nodeDescriptor.getName());
            }
            typeName = XMLPoolingDataSourceFactory.class.getName();
        }
        return this.objectFactory.newInstance(DataSourceFactory.class, typeName);
    }

    protected boolean shouldConfigureDataSourceFromProperties(DataNodeDescriptor nodeDescriptor) {
        String channelName = nodeDescriptor.getDataChannelDescriptor() != null ? nodeDescriptor.getDataChannelDescriptor().getName() : null;
        String driver = this.getProperty("cayenne.jdbc.driver");
        if (driver == null && channelName != null) {
            driver = this.getProperty("cayenne.jdbc.driver." + nodeDescriptor.getDataChannelDescriptor().getName() + "." + nodeDescriptor.getName());
        }
        if (driver == null) {
            return false;
        }
        String url = this.getProperty("cayenne.jdbc.url");
        if (url == null && channelName != null) {
            url = this.getProperty("cayenne.jdbc.url." + nodeDescriptor.getDataChannelDescriptor().getName() + "." + nodeDescriptor.getName());
        }
        if (url == null) {
            return false;
        }
        logger.info((Object)String.format("Found DataSourceFactory system property overrides for URL and Driver of '%s.%s' node. Will ignore project DataSource configuration.", channelName, nodeDescriptor.getName()));
        return true;
    }

    protected String getProperty(String key) {
        return System.getProperty(key);
    }
}

