/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.regex.Pattern;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ConditionNode;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.util.Util;

public abstract class PatternMatchNode
extends ConditionNode {
    protected Pattern pattern;
    protected boolean patternCompiled;
    protected boolean ignoringCase;
    protected char escapeChar;

    PatternMatchNode(int i, boolean ignoringCase) {
        super(i);
        this.ignoringCase = ignoringCase;
    }

    PatternMatchNode(int i, boolean ignoringCase, char escapeChar) {
        super(i);
        this.ignoringCase = ignoringCase;
        this.setEscapeChar(escapeChar);
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char value) {
        if ('?' == value) {
            throw new CayenneRuntimeException("the use of the '?' as an escape character in LIKE clauses is disallowed.", new Object[0]);
        }
        this.escapeChar = value;
    }

    protected boolean matchPattern(String string) {
        return string != null ? this.getPattern().matcher(string).find() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pattern getPattern() {
        if (!this.patternCompiled) {
            PatternMatchNode patternMatchNode = this;
            synchronized (patternMatchNode) {
                if (!this.patternCompiled) {
                    this.pattern = null;
                    if (this.jjtGetNumChildren() < 2) {
                        this.patternCompiled = true;
                        return null;
                    }
                    ASTScalar patternNode = (ASTScalar)this.jjtGetChild(1);
                    if (patternNode == null) {
                        this.patternCompiled = true;
                        return null;
                    }
                    String srcPattern = (String)patternNode.getValue();
                    if (srcPattern == null) {
                        this.patternCompiled = true;
                        return null;
                    }
                    this.pattern = Util.sqlPatternToPattern(srcPattern, this.ignoringCase);
                    this.patternCompiled = true;
                }
            }
        }
        return this.pattern;
    }

    public void jjtAddChild(Node n, int i) {
        if (i == 1) {
            this.patternCompiled = false;
        }
        super.jjtAddChild(n, i);
    }
}

