/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.event.SnapshotEvent;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventBridgeFactory;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.graph.GraphManager;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataRowStore
implements Serializable {
    private static Log logger = LogFactory.getLog(DataRowStore.class);
    public static final String SNAPSHOT_EXPIRATION_PROPERTY = "cayenne.DataRowStore.snapshot.expiration";
    public static final String SNAPSHOT_CACHE_SIZE_PROPERTY = "cayenne.DataRowStore.snapshot.size";
    public static final String REMOTE_NOTIFICATION_PROPERTY = "cayenne.DataRowStore.remote.notify";
    public static final String EVENT_BRIDGE_FACTORY_PROPERTY = "cayenne.DataRowStore.EventBridge.factory";
    public static final long SNAPSHOT_EXPIRATION_DEFAULT = 7200L;
    public static final int SNAPSHOT_CACHE_SIZE_DEFAULT = 10000;
    public static final boolean REMOTE_NOTIFICATION_DEFAULT = false;
    public static final String EVENT_BRIDGE_FACTORY_DEFAULT = "org.apache.cayenne.event.JavaGroupsBridgeFactory";
    protected String name;
    protected LRUMap snapshots;
    protected boolean notifyingRemoteListeners;
    protected transient EventManager eventManager;
    protected transient EventBridge remoteNotificationsHandler;
    protected transient EventSubject eventSubject;

    public DataRowStore(String name) {
        this(name, Collections.EMPTY_MAP);
    }

    public DataRowStore(String name, Map properties) {
        this(name, properties, new EventManager());
    }

    public DataRowStore(String name, Map properties, EventManager eventManager) {
        if (name == null) {
            throw new IllegalArgumentException("DataRowStore name can't be null.");
        }
        this.name = name;
        this.eventSubject = this.createSubject();
        this.eventManager = eventManager;
        this.initWithProperties(properties);
    }

    private EventSubject createSubject() {
        return EventSubject.getSubject(this.getClass(), this.name);
    }

    protected void initWithProperties(Map properties) {
        ExtendedProperties propertiesWrapper = new ExtendedProperties();
        if (properties != null) {
            propertiesWrapper.putAll(properties);
        }
        long snapshotsExpiration = propertiesWrapper.getLong(SNAPSHOT_EXPIRATION_PROPERTY, 7200L);
        int snapshotsCacheSize = propertiesWrapper.getInt(SNAPSHOT_CACHE_SIZE_PROPERTY, 10000);
        boolean notifyRemote = propertiesWrapper.getBoolean(REMOTE_NOTIFICATION_PROPERTY, false);
        String eventBridgeFactory = propertiesWrapper.getString(EVENT_BRIDGE_FACTORY_PROPERTY, EVENT_BRIDGE_FACTORY_DEFAULT);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DataRowStore property cayenne.DataRowStore.snapshot.expiration = " + snapshotsExpiration));
            logger.debug((Object)("DataRowStore property cayenne.DataRowStore.snapshot.size = " + snapshotsCacheSize));
            logger.debug((Object)("DataRowStore property cayenne.DataRowStore.remote.notify = " + notifyRemote));
            logger.debug((Object)("DataRowStore property cayenne.DataRowStore.EventBridge.factory = " + eventBridgeFactory));
        }
        this.notifyingRemoteListeners = notifyRemote;
        this.snapshots = new LRUMap(snapshotsCacheSize);
        if (this.notifyingRemoteListeners) {
            try {
                EventBridgeFactory factory = (EventBridgeFactory)Class.forName(eventBridgeFactory).newInstance();
                Set<EventSubject> subjects = Collections.singleton(this.getSnapshotEventSubject());
                String externalSubject = EventBridge.convertToExternalSubject(this.getSnapshotEventSubject());
                this.remoteNotificationsHandler = factory.createEventBridge(subjects, externalSubject, properties);
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error initializing DataRowStore.", ex);
            }
            this.startListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshotsUpdatedForObjects(List objects, List snapshots, boolean refresh) {
        int size = objects.size();
        if (size != snapshots.size()) {
            throw new IllegalArgumentException("Counts of objects and corresponding snapshots do not match. Objects count: " + objects.size() + ", snapshots count: " + snapshots.size());
        }
        HashMap<ObjectId, DataRow> modified = null;
        GraphManager eventPostedBy = null;
        DataRowStore dataRowStore = this;
        synchronized (dataRowStore) {
            for (int i = 0; i < size; ++i) {
                Persistent object = (Persistent)objects.get(i);
                if (object == null || object.getPersistenceState() == 5) continue;
                ObjectId oid = object.getObjectId();
                DataRow cachedSnapshot = (DataRow)this.snapshots.get((Object)oid);
                if (!refresh && cachedSnapshot != null) continue;
                DataRow newSnapshot = (DataRow)snapshots.get(i);
                if (cachedSnapshot != null) {
                    if (object instanceof DataObject && cachedSnapshot.equals(newSnapshot)) {
                        ((DataObject)object).setSnapshotVersion(cachedSnapshot.getVersion());
                        continue;
                    }
                    newSnapshot.setReplacesVersion(cachedSnapshot.getVersion());
                }
                if (modified == null) {
                    modified = new HashMap<ObjectId, DataRow>();
                    eventPostedBy = object.getObjectContext().getGraphManager();
                }
                modified.put(oid, newSnapshot);
            }
            if (modified != null) {
                this.processSnapshotChanges(eventPostedBy, modified, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            }
        }
    }

    public int size() {
        return this.snapshots.size();
    }

    public int maximumSize() {
        return this.snapshots.maxSize();
    }

    public void shutdown() {
        this.stopListeners();
        this.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        if (eventManager != this.eventManager) {
            this.stopListeners();
            this.eventManager = eventManager;
            this.startListeners();
        }
    }

    public synchronized DataRow getCachedSnapshot(ObjectId oid) {
        return (DataRow)this.snapshots.get((Object)oid);
    }

    public EventSubject getSnapshotEventSubject() {
        return this.eventSubject;
    }

    public synchronized void clear() {
        this.snapshots.clear();
    }

    public synchronized void forgetSnapshot(ObjectId id) {
        this.snapshots.remove((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemoteEvent(SnapshotEvent event) {
        if (event.getSource() != this.remoteNotificationsHandler) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("remote event: " + event));
        }
        Collection deletedSnapshotIds = event.getDeletedIds();
        Collection invalidatedSnapshotIds = event.getInvalidatedIds();
        Map diffs = event.getModifiedDiffs();
        Collection indirectlyModifiedIds = event.getIndirectlyModifiedIds();
        if (deletedSnapshotIds.isEmpty() && invalidatedSnapshotIds.isEmpty() && diffs.isEmpty() && indirectlyModifiedIds.isEmpty()) {
            logger.warn((Object)"processRemoteEvent.. bogus call... no changes.");
            return;
        }
        DataRowStore dataRowStore = this;
        synchronized (dataRowStore) {
            this.processDeletedIDs(deletedSnapshotIds);
            this.processInvalidatedIDs(deletedSnapshotIds);
            this.processUpdateDiffs(diffs);
            this.sendUpdateNotification(event.getPostedBy(), diffs, deletedSnapshotIds, invalidatedSnapshotIds, indirectlyModifiedIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSnapshotChanges(Object postedBy, Map updatedSnapshots, Collection deletedSnapshotIds, Collection invalidatedSnapshotIds, Collection indirectlyModifiedIds) {
        if (deletedSnapshotIds.isEmpty() && invalidatedSnapshotIds.isEmpty() && updatedSnapshots.isEmpty() && indirectlyModifiedIds.isEmpty()) {
            logger.warn((Object)"postSnapshotsChangeEvent.. bogus call... no changes.");
            return;
        }
        DataRowStore dataRowStore = this;
        synchronized (dataRowStore) {
            this.processDeletedIDs(deletedSnapshotIds);
            this.processInvalidatedIDs(invalidatedSnapshotIds);
            Map diffs = this.processUpdatedSnapshots(updatedSnapshots);
            this.sendUpdateNotification(postedBy, diffs, deletedSnapshotIds, invalidatedSnapshotIds, indirectlyModifiedIds);
        }
    }

    private void processDeletedIDs(Collection deletedSnapshotIDs) {
        if (!deletedSnapshotIDs.isEmpty()) {
            Iterator it = deletedSnapshotIDs.iterator();
            while (it.hasNext()) {
                this.snapshots.remove(it.next());
            }
        }
    }

    private void processInvalidatedIDs(Collection invalidatedSnapshotIds) {
        if (!invalidatedSnapshotIds.isEmpty()) {
            Iterator it = invalidatedSnapshotIds.iterator();
            while (it.hasNext()) {
                this.snapshots.remove(it.next());
            }
        }
    }

    private Map processUpdatedSnapshots(Map updatedSnapshots) {
        HashMap<ObjectId, DataRow> diffs = null;
        if (!updatedSnapshots.isEmpty()) {
            for (Map.Entry entry : updatedSnapshots.entrySet()) {
                DataRow newSnapshot;
                ObjectId key = (ObjectId)entry.getKey();
                DataRow oldSnapshot = (DataRow)this.snapshots.put((Object)key, (Object)(newSnapshot = (DataRow)entry.getValue()));
                if (oldSnapshot == null) continue;
                if (oldSnapshot.getVersion() != newSnapshot.getReplacesVersion()) {
                    logger.debug((Object)("snapshot version changed, don't know what to do... Old: " + oldSnapshot + ", New: " + newSnapshot));
                    this.forgetSnapshot(key);
                    continue;
                }
                DataRow diff = oldSnapshot.createDiff(newSnapshot);
                if (diff == null) continue;
                if (diffs == null) {
                    diffs = new HashMap<ObjectId, DataRow>();
                }
                diffs.put(key, diff);
            }
        }
        return diffs;
    }

    private void processUpdateDiffs(Map diffs) {
        if (!diffs.isEmpty()) {
            for (Map.Entry entry : diffs.entrySet()) {
                ObjectId key = (ObjectId)entry.getKey();
                DataRow oldSnapshot = (DataRow)this.snapshots.remove((Object)key);
                if (oldSnapshot == null) continue;
                DataRow newSnapshot = oldSnapshot.applyDiff((DataRow)entry.getValue());
                this.snapshots.put((Object)key, (Object)newSnapshot);
            }
        }
    }

    private void sendUpdateNotification(Object postedBy, Map diffs, Collection deletedSnapshotIDs, Collection invalidatedSnapshotIDs, Collection indirectlyModifiedIds) {
        if (diffs != null && !diffs.isEmpty() || deletedSnapshotIDs != null && !deletedSnapshotIDs.isEmpty() || invalidatedSnapshotIDs != null && !invalidatedSnapshotIDs.isEmpty() || indirectlyModifiedIds != null && !indirectlyModifiedIds.isEmpty()) {
            SnapshotEvent event = new SnapshotEvent(this, postedBy, diffs, deletedSnapshotIDs, invalidatedSnapshotIDs, indirectlyModifiedIds);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("postSnapshotsChangeEvent: " + event));
            }
            this.eventManager.postEvent(event, this.getSnapshotEventSubject());
        }
    }

    public boolean isNotifyingRemoteListeners() {
        return this.notifyingRemoteListeners;
    }

    public void setNotifyingRemoteListeners(boolean notifyingRemoteListeners) {
        this.notifyingRemoteListeners = notifyingRemoteListeners;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.eventSubject = this.createSubject();
    }

    void stopListeners() {
        if (this.eventManager != null) {
            this.eventManager.removeListener(this);
        }
        if (this.remoteNotificationsHandler != null) {
            try {
                this.remoteNotificationsHandler.shutdown();
            }
            catch (Exception ex) {
                logger.info((Object)"Exception shutting down EventBridge.", (Throwable)ex);
            }
            this.remoteNotificationsHandler = null;
        }
    }

    void startListeners() {
        if (this.eventManager != null && this.remoteNotificationsHandler != null) {
            try {
                this.eventManager.addNonBlockingListener(this, "processRemoteEvent", SnapshotEvent.class, this.getSnapshotEventSubject(), this.remoteNotificationsHandler);
                this.remoteNotificationsHandler.startup(this.eventManager, 3);
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error initializing DataRowStore.", ex);
            }
        }
    }
}

