/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.MappingNamesHelper;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class ObjRelationshipValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        ObjRelationship inverse;
        ObjRelationship rel = (ObjRelationship)path.getObject();
        if (path.getObjectParent() != null && path.getObjectParent() != rel.getSourceEntity()) {
            return;
        }
        if (Util.isEmptyString(rel.getName())) {
            validator.registerError("Unnamed ObjRelationship.", path);
        } else if (rel.getSourceEntity().getAttribute(rel.getName()) != null) {
            validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has the same name as one of ObjAttributes", path);
        } else {
            MappingNamesHelper helper = MappingNamesHelper.getInstance();
            String invalidChars = helper.invalidCharsInObjPathComponent(rel.getName());
            if (invalidChars != null) {
                validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " name contains invalid characters: " + invalidChars, path);
            } else if (helper.invalidDataObjectProperty(rel.getName())) {
                validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " name is invalid.", path);
            }
        }
        if (rel.getTargetEntity() == null) {
            validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has no target entity.", path);
        } else {
            List<DbRelationship> dbRels = rel.getDbRelationships();
            if (dbRels.size() == 0) {
                validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has no DbRelationship mapping.", path);
            } else {
                DbEntity expectedSrc = ((ObjEntity)rel.getSourceEntity()).getDbEntity();
                DbEntity expectedTarget = ((ObjEntity)rel.getTargetEntity()).getDbEntity();
                if (dbRels.get(0).getSourceEntity() != expectedSrc || dbRels.get(dbRels.size() - 1).getTargetEntity() != expectedTarget) {
                    validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has incomplete DbRelationship mapping.", path);
                }
            }
        }
        if (rel.isToMany() && !rel.isFlattened() && rel.getDeleteRule() == 1 && (inverse = rel.getReverseRelationship()) != null) {
            DbRelationship firstRel = inverse.getDbRelationships().get(0);
            Iterator<DbJoin> attributePairIterator = firstRel.getJoins().iterator();
            boolean check = true;
            while (attributePairIterator.hasNext()) {
                DbJoin pair = attributePairIterator.next();
                if (pair.getSource().isMandatory()) continue;
                check = false;
                break;
            }
            if (check) {
                validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has a Nullify delete rule and a mandatory reverse relationship ", path);
            }
        }
    }

    public String objRelationshipIdentifier(ObjRelationship rel) {
        if (null == rel.getSourceEntity()) {
            return "<[null source entity]." + rel.getName() + ">";
        }
        return "<" + rel.getSourceEntity().getName() + "." + rel.getName() + ">";
    }
}

