/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.io.IOException;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.map.DbAttribute;

public class TrimmingQualifierTranslator
extends QualifierTranslator {
    protected String trimFunction;

    public TrimmingQualifierTranslator(QueryAssembler queryAssembler, String trimFunction) {
        super(queryAssembler);
        this.trimFunction = trimFunction;
    }

    protected void processColumn(DbAttribute dbAttr) throws IOException {
        if (dbAttr.getType() == 1) {
            this.out.append(this.trimFunction).append("(");
            super.processColumn(dbAttr);
            this.out.append(')');
        } else {
            super.processColumn(dbAttr);
        }
    }

    protected void processColumnWithQuoteSqlIdentifiers(DbAttribute dbAttr) throws IOException {
        if (dbAttr.getType() == 1) {
            this.out.append(this.trimFunction).append("(");
            super.processColumnWithQuoteSqlIdentifiers(dbAttr);
            this.out.append(')');
        } else {
            super.processColumnWithQuoteSqlIdentifiers(dbAttr);
        }
    }

    public String getTrimFunction() {
        return this.trimFunction;
    }

    public void setTrimFunction(String trimFunction) {
        this.trimFunction = trimFunction;
    }
}

