/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.util.List;
import org.apache.cayenne.access.select.EntityRowReader;
import org.apache.cayenne.access.select.EntitySegment;
import org.apache.cayenne.access.select.EntitySelectColumn;
import org.apache.cayenne.access.select.MappedColumnBuilder;
import org.apache.cayenne.access.select.RowReader;
import org.apache.cayenne.access.select.ScalarRowReader;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.QueryMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntitySegmentBuilder
extends MappedColumnBuilder {
    protected QueryMetadata metadata;
    protected ObjEntity entity;

    EntitySegmentBuilder(QueryMetadata metadata, ExtendedTypeMap extendedTypes, ObjEntity entity) {
        super(extendedTypes);
        this.entity = entity;
        this.metadata = metadata;
    }

    List<EntitySelectColumn> buildColumns() {
        if (this.metadata.getPageSize() > 0) {
            this.appendId();
        } else {
            this.appendAll();
        }
        return this.columns;
    }

    EntitySegment buildSegment() {
        RowReader<Object> rowReader;
        this.buildColumns();
        if (this.metadata.getPageSize() > 0 && this.columns.size() == 1) {
            EntitySelectColumn column = (EntitySelectColumn)this.columns.get(0);
            rowReader = new ScalarRowReader(column.getConverter(), column.getJdbcType());
        } else {
            rowReader = new EntityRowReader(this.entity.getName(), this.columns);
        }
        return new EntitySegment(rowReader, this.columns);
    }

    protected void appendId() {
        this.appendIdObjAttributes();
        this.appendIdDbAttributes();
    }

    protected void appendAll() {
        this.appendObjAttributes();
        this.appendIdDbAttributes();
        this.appendFK();
        this.appendJointPrefetches();
    }

    protected void appendIdObjAttributes() {
        for (ObjAttribute attribute : this.entity.getDeclaredAttributes()) {
            if (!attribute.isPrimaryKey()) continue;
            this.append(attribute);
        }
    }

    protected void appendObjAttributes() {
        for (ObjAttribute attribute : this.entity.getDeclaredAttributes()) {
            this.append(attribute);
        }
    }

    protected void appendIdDbAttributes() {
        if (this.entity.getDbEntityName() != null) {
            for (DbAttribute attribute : this.entity.getDbEntity().getPrimaryKeys()) {
                this.append(attribute);
            }
        }
    }

    protected void appendFK() {
        for (ObjRelationship relationship : this.entity.getDeclaredRelationships()) {
            DbRelationship dbRel = relationship.getDbRelationships().get(0);
            List<DbJoin> joins = dbRel.getJoins();
            int len = joins.size();
            for (int i = 0; i < len; ++i) {
                this.append(joins.get(i).getSource());
            }
        }
    }

    protected void appendJointPrefetches() {
        if (this.metadata.getPrefetchTree() != null) {
            throw new UnsupportedOperationException("TODO: joint prefetches");
        }
    }
}

